/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.exception.InvalidCommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapCodec {
    private final RunMiNiFi runner;
    private final BufferedReader reader;
    private final BufferedWriter writer;
    private final Logger logger = LoggerFactory.getLogger(BootstrapCodec.class);

    public BootstrapCodec(RunMiNiFi runner, InputStream in, OutputStream out) {
        this.runner = runner;
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.writer = new BufferedWriter(new OutputStreamWriter(out));
    }

    public void communicate() throws IOException {
        String line = this.reader.readLine();
        String[] splits = line.split(" ");
        if (splits.length < 0) {
            throw new IOException("Received invalid command from MiNiFi: " + line);
        }
        String cmd = splits[0];
        String[] args = splits.length == 1 ? new String[]{} : Arrays.copyOfRange(splits, 1, splits.length);
        try {
            this.processRequest(cmd, args);
        }
        catch (InvalidCommandException ice) {
            throw new IOException("Received invalid command from MiNiFi: " + line + " : " + (ice.getMessage() == null ? "" : "Details: " + ice.toString()));
        }
    }

    private void processRequest(String cmd, String[] args) throws InvalidCommandException, IOException {
        switch (cmd) {
            case "PORT": {
                int port;
                this.logger.debug("Received 'PORT' command from MINIFI");
                if (args.length != 2) {
                    throw new InvalidCommandException();
                }
                try {
                    port = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidCommandException("Invalid Port number; should be integer between 1 and 65535");
                }
                if (port < 1 || port > 65535) {
                    throw new InvalidCommandException("Invalid Port number; should be integer between 1 and 65535");
                }
                String secretKey = args[1];
                this.runner.setMiNiFiCommandControlPort(port, secretKey);
                this.writer.write("OK");
                this.writer.newLine();
                this.writer.flush();
                break;
            }
            case "STARTED": {
                this.logger.debug("Received 'STARTED' command from MINIFI");
                if (args.length != 1) {
                    throw new InvalidCommandException("STARTED command must contain a status argument");
                }
                if (!"true".equals(args[0]) && !"false".equals(args[0])) {
                    throw new InvalidCommandException("Invalid status for STARTED command; should be true or false, but was '" + args[0] + "'");
                }
                boolean started = Boolean.parseBoolean(args[0]);
                this.runner.setNiFiStarted(started);
                this.writer.write("OK");
                this.writer.newLine();
                this.writer.flush();
                break;
            }
            case "SHUTDOWN": {
                this.logger.debug("Received 'SHUTDOWN' command from MINIFI");
                this.runner.shutdownChangeNotifier();
                this.runner.shutdownPeriodicStatusReporters();
                this.writer.write("OK");
                this.writer.newLine();
                this.writer.flush();
            }
        }
    }
}

