/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.plugin.surefire.log.PluginConsoleLogger;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.api.testset.TestSetFailedException;
import org.apache.maven.surefire.api.util.internal.DumpFileUtils;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.shared.lang3.SystemUtils;

public final class SurefireHelper {
    private static final String DUMP_FILE_DATE = DumpFileUtils.newFormattedDateFileName();
    public static final String DUMP_FILE_PREFIX = DUMP_FILE_DATE + "-jvmRun";
    public static final String DUMP_FILENAME_FORMATTER = DUMP_FILE_PREFIX + "%d" + ".dump";
    public static final String DUMPSTREAM_FILENAME_FORMATTER = DUMP_FILE_PREFIX + "%d" + ".dumpstream";
    public static final String DUMPSTREAM_FILENAME = DUMP_FILE_DATE + ".dumpstream";
    public static final String DUMP_FILENAME = DUMP_FILE_DATE + ".dump";
    public static final String EVENTS_BINARY_DUMP_FILENAME_FORMATTER = DUMP_FILE_DATE + "-jvmRun%d-events.bin";
    private static final int MAX_PATH_LENGTH_WINDOWS = 247;
    private static final String[] DUMP_FILES_PRINT = new String[]{"[date].dump", "[date]-jvmRun[N].dump", "[date].dumpstream", "[date]-jvmRun[N].dumpstream"};
    private static final String THREAD_NUMBER_PLACEHOLDER = "${surefire.threadNumber}";
    private static final String FORK_NUMBER_PLACEHOLDER = "${surefire.forkNumber}";

    private SurefireHelper() {
        throw new IllegalAccessError("Utility class");
    }

    @Nonnull
    public static String replaceThreadNumberPlaceholders(@Nonnull String argLine, int threadNumber) {
        String threadNumberAsString = String.valueOf(threadNumber);
        return argLine.replace(THREAD_NUMBER_PLACEHOLDER, threadNumberAsString).replace(FORK_NUMBER_PLACEHOLDER, threadNumberAsString);
    }

    public static File replaceForkThreadsInPath(File path, int replacement) {
        LinkedList<String> dirs = new LinkedList<String>();
        File root = path;
        while (!root.exists()) {
            dirs.addFirst(SurefireHelper.replaceThreadNumberPlaceholders(root.getName(), replacement));
            root = root.getParentFile();
        }
        File replacedPath = root;
        for (String dir : dirs) {
            replacedPath = new File(replacedPath, dir);
        }
        return replacedPath;
    }

    public static String[] getDumpFilesToPrint() {
        return (String[])DUMP_FILES_PRINT.clone();
    }

    public static void reportExecution(SurefireReportParameters reportParameters, RunResult result, PluginConsoleLogger log, Exception firstForkException) throws MojoFailureException, MojoExecutionException {
        boolean isError = firstForkException != null || result.isTimeout() || !result.isErrorFree();
        boolean isTooFlaky = SurefireHelper.isTooFlaky(result, reportParameters);
        if (!isError && !isTooFlaky) {
            if (result.getCompletedCount() == 0 && SurefireHelper.failIfNoTests(reportParameters)) {
                throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
            }
            return;
        }
        if (reportParameters.isTestFailureIgnore()) {
            String errorMessage = SurefireHelper.createErrorMessage(reportParameters, result, firstForkException);
            if (firstForkException instanceof SurefireBooterForkException) {
                throw new MojoExecutionException(errorMessage, firstForkException);
            }
            log.error(errorMessage);
        } else {
            SurefireHelper.throwException(reportParameters, result, firstForkException);
        }
    }

    public static List<CommandLineOption> commandLineOptions(MavenSession session, PluginConsoleLogger log) {
        String failureBehavior;
        MavenExecutionRequest request;
        ArrayList<CommandLineOption> cli = new ArrayList<CommandLineOption>();
        if (log.isErrorEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_ERROR);
        }
        if (log.isWarnEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_WARN);
        }
        if (log.isInfoEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_INFO);
        }
        if (log.isDebugEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_DEBUG);
        }
        if ((request = session.getRequest()).isShowErrors()) {
            cli.add(CommandLineOption.SHOW_ERRORS);
        }
        if ((failureBehavior = request.getReactorFailureBehavior()) != null) {
            try {
                cli.add(CommandLineOption.valueOf((String)failureBehavior));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(cli);
    }

    public static void logDebugOrCliShowErrors(String s, PluginConsoleLogger log, Collection<CommandLineOption> cli) {
        if (cli.contains(CommandLineOption.LOGGING_LEVEL_DEBUG)) {
            log.debug(s);
        } else if (cli.contains(CommandLineOption.SHOW_ERRORS)) {
            if (log.isDebugEnabled()) {
                log.debug(s);
            } else {
                log.info(s);
            }
        }
    }

    public static String escapeToPlatformPath(String path) {
        if (SystemUtils.IS_OS_WINDOWS && path.length() > 247) {
            path = path.startsWith("\\\\") ? "\\\\?\\UNC\\" + path.substring(2) : "\\\\?\\" + path;
        }
        return path;
    }

    private static boolean failIfNoTests(SurefireReportParameters reportParameters) {
        return reportParameters.getFailIfNoTests();
    }

    private static boolean isFatal(Exception firstForkException) {
        return firstForkException != null && !(firstForkException instanceof TestSetFailedException);
    }

    private static void throwException(SurefireReportParameters reportParameters, RunResult result, Exception firstForkException) throws MojoFailureException, MojoExecutionException {
        if (SurefireHelper.isFatal(firstForkException) || result.isInternalError()) {
            throw new MojoExecutionException(SurefireHelper.createErrorMessage(reportParameters, result, firstForkException), firstForkException);
        }
        throw new MojoFailureException(SurefireHelper.createErrorMessage(reportParameters, result, firstForkException), (Throwable)firstForkException);
    }

    private static String createErrorMessage(SurefireReportParameters reportParameters, RunResult result, Exception firstForkException) {
        StringBuilder msg = new StringBuilder(512);
        if (result.isTimeout()) {
            msg.append("There was a timeout in the fork");
        } else {
            if (result.getFailures() > 0) {
                msg.append("There are test failures.");
            }
            if (SurefireHelper.isTooFlaky(result, reportParameters)) {
                if (result.getFailures() > 0) {
                    msg.append("\n");
                }
                msg.append("There").append(result.getFlakes() == 1 ? " is " : " are ").append(result.getFlakes()).append(result.getFlakes() == 1 ? " flake " : " flakes ").append("and failOnFlakeCount is set to ").append(reportParameters.getFailOnFlakeCount()).append(".");
            }
            msg.append("\n\nSee ").append(reportParameters.getReportsDirectory()).append(" for the individual test results.").append('\n').append("See dump files (if any exist) ").append(DUMP_FILES_PRINT[0]).append(", ").append(DUMP_FILES_PRINT[1]).append(" and ").append(DUMP_FILES_PRINT[2]).append(".");
        }
        if (firstForkException != null && firstForkException.getLocalizedMessage() != null) {
            msg.append('\n').append(firstForkException.getLocalizedMessage());
        }
        if (result.isFailure()) {
            msg.append('\n').append(result.getFailure());
        }
        return msg.toString();
    }

    private static boolean isTooFlaky(RunResult result, SurefireReportParameters reportParameters) {
        int failOnFlakeCount = reportParameters.getFailOnFlakeCount();
        return failOnFlakeCount > 0 && result.getFlakes() >= failOnFlakeCount;
    }
}

