/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import org.apache.maven.surefire.shared.lang3.SystemUtils;

public final class FileReporterUtils {
    private FileReporterUtils() {
        throw new IllegalStateException("non instantiable constructor");
    }

    public static String stripIllegalFilenameChars(String original) {
        StringBuilder result = new StringBuilder(original);
        String illegalChars = FileReporterUtils.getOSSpecificIllegalChars();
        int len = result.length();
        for (int i = 0; i < len; ++i) {
            boolean isIllegalChar;
            char charFromOriginal = result.charAt(i);
            boolean bl = isIllegalChar = illegalChars.indexOf(charFromOriginal) != -1;
            if (!isIllegalChar) continue;
            result.setCharAt(i, '_');
        }
        return result.toString();
    }

    private static String getOSSpecificIllegalChars() {
        return SystemUtils.IS_OS_WINDOWS ? "[],\\/:*?\"<>|\u0000" : "()&\\/:*?\"<>|\u0000";
    }
}

