/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.maven.plugin.surefire.report.TestcycleConsoleOutputReceiver;
import org.apache.maven.surefire.report.ReportEntry;

public class DirectConsoleOutput
implements TestcycleConsoleOutputReceiver {
    private static final Charset STANDARD_CHARSET = Charset.defaultCharset();
    private final PrintStream sout;
    private final PrintStream serr;

    public DirectConsoleOutput(PrintStream sout, PrintStream serr) {
        this.sout = Objects.requireNonNull(sout);
        this.serr = Objects.requireNonNull(serr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTestOutput(byte[] buf, int off, int len, boolean stdout) {
        PrintStream stream;
        PrintStream printStream = stream = stdout ? this.sout : this.serr;
        synchronized (printStream) {
            try {
                CharBuffer decode = STANDARD_CHARSET.newDecoder().decode(ByteBuffer.wrap(buf, off, len));
                stream.append(decode);
            }
            catch (CharacterCodingException e) {
                stream.write(buf, off, len);
            }
        }
    }

    @Override
    public void testSetStarting(ReportEntry reportEntry) {
    }

    @Override
    public void testSetCompleted(ReportEntry report) {
    }

    @Override
    public void close() {
    }
}

