/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.shared.dependency.analyzer.ClassFileVisitor;

public final class ClassFileVisitorUtils {
    private ClassFileVisitorUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void accept(URL url, ClassFileVisitor visitor) throws IOException {
        if (url.getPath().endsWith(".jar")) {
            ClassFileVisitorUtils.acceptJar(url, visitor);
            return;
        }
        if (!url.getProtocol().equalsIgnoreCase("file")) throw new IllegalArgumentException("Cannot accept visitor on URL: " + url);
        try {
            File file = new File(new URI(url.toString()));
            if (file.isDirectory()) {
                ClassFileVisitorUtils.acceptDirectory(file, visitor);
                return;
            } else {
                if (!file.exists()) return;
                throw new IllegalArgumentException("Cannot accept visitor on URL: " + url);
            }
        }
        catch (URISyntaxException exception) {
            throw new IllegalArgumentException("Cannot accept visitor on URL: " + url, exception);
        }
    }

    private static void acceptJar(URL url, ClassFileVisitor visitor) throws IOException {
        try (JarInputStream in = new JarInputStream(url.openStream());){
            JarEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".class") || name.indexOf(45) != -1) continue;
                ClassFileVisitorUtils.visitClass(name, in, visitor, '/');
            }
        }
    }

    private static void acceptDirectory(File directory, ClassFileVisitor visitor) throws IOException {
        List classFiles;
        try (Stream<Path> walk = Files.walk(directory.toPath(), new FileVisitOption[0]);){
            classFiles = walk.filter(path -> path.getFileName().toString().endsWith(".class")).collect(Collectors.toList());
        }
        for (Path path2 : classFiles) {
            InputStream in = Files.newInputStream(path2, new OpenOption[0]);
            try {
                try {
                    ClassFileVisitorUtils.visitClass(directory, path2, in, visitor);
                }
                catch (RuntimeException e) {
                    throw new RuntimeException(String.format("%s from directory = %s, path = %s", e.getMessage(), directory, path2), e);
                }
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    private static void visitClass(File baseDirectory, Path path, InputStream in, ClassFileVisitor visitor) {
        String stringPath = path.toFile().getPath().substring(baseDirectory.getPath().length() + 1);
        ClassFileVisitorUtils.visitClass(stringPath, in, visitor, File.separatorChar);
    }

    private static void visitClass(String stringPath, InputStream in, ClassFileVisitor visitor, char separator) {
        String className = stringPath.substring(0, stringPath.length() - 6);
        className = className.replace(separator, '.');
        visitor.visitClass(className, in);
    }
}

