/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.perforce.command.update;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.util.AbstractConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class PerforceHaveConsumer
extends AbstractConsumer {
    private String have;
    private RE revisionRegexp;
    private static final String PATTERN = "^Change (\\d+) on (.*) by (.*)@";

    public PerforceHaveConsumer(ScmLogger logger) {
        block2: {
            super(logger);
            try {
                this.revisionRegexp = new RE(PATTERN);
            }
            catch (RESyntaxException ignored) {
                if (!this.getLogger().isErrorEnabled()) break block2;
                this.getLogger().error("Could not create regexp to parse perforce log file", (Throwable)ignored);
            }
        }
    }

    public String getHave() throws ScmException {
        return this.have;
    }

    public void consumeLine(String line) {
        if (this.revisionRegexp.match(line)) {
            this.have = this.revisionRegexp.getParen(1);
        }
    }
}

