/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.IOUtil;

public final class PropertyUtils {
    private PropertyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertyFile(File propFile, Properties baseProps) throws IOException {
        if (!propFile.exists()) {
            throw new FileNotFoundException(propFile.toString());
        }
        Properties fileProps = new Properties();
        FileInputStream inStream = new FileInputStream(propFile);
        try {
            fileProps.load(inStream);
        }
        finally {
            IOUtil.close((InputStream)inStream);
        }
        Properties combinedProps = new Properties();
        combinedProps.putAll((Map<?, ?>)baseProps);
        combinedProps.putAll((Map<?, ?>)fileProps);
        for (Object o : fileProps.keySet()) {
            String k = (String)o;
            String propValue = PropertyUtils.getPropertyValue(k, combinedProps);
            fileProps.setProperty(k, propValue);
        }
        return fileProps;
    }

    public static Properties loadPropertyFile(File propfile, boolean fail, boolean useSystemProps) throws IOException {
        Properties resolvedProps;
        Properties baseProps;
        block4: {
            baseProps = new Properties();
            if (useSystemProps) {
                baseProps.putAll((Map<?, ?>)System.getProperties());
            }
            resolvedProps = new Properties();
            try {
                resolvedProps.putAll((Map<?, ?>)PropertyUtils.loadPropertyFile(propfile, baseProps));
            }
            catch (FileNotFoundException e) {
                if (!fail) break block4;
                throw new FileNotFoundException(propfile.toString());
            }
        }
        if (useSystemProps) {
            resolvedProps.putAll((Map<?, ?>)baseProps);
        }
        return resolvedProps;
    }

    private static String getPropertyValue(String k, Properties p) {
        int idx;
        String v = p.getProperty(k);
        String ret = "";
        while ((idx = v.indexOf("${")) >= 0) {
            ret = ret + v.substring(0, idx);
            int idx2 = (v = v.substring(idx + 2)).indexOf(125);
            if (idx2 < 0) break;
            String nk = v.substring(0, idx2);
            v = v.substring(idx2 + 1);
            String nv = p.getProperty(nk);
            if (nv == null) {
                nv = System.getProperty(nk);
            }
            if (nv == null || nv.equals(k)) {
                ret = ret + "${" + nk + "}";
                continue;
            }
            v = nv + v;
        }
        return ret + v;
    }
}

