/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.rad;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.apache.maven.plugin.ide.IdeDependency;
import org.apache.maven.plugin.ide.IdeUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.FileUtils;

public class RadLibCopier
extends AbstractEclipseWriter {
    public void write() throws MojoExecutionException {
        IdeDependency[] deps = this.config.getDeps();
        String packaging = this.config.getPackaging();
        if ("ear".equals(packaging)) {
            this.handleEarLibs(deps);
        } else if ("war".equals(packaging)) {
            this.handleWarLibs(deps);
        }
    }

    private void copyArtifact(IdeDependency[] deps, File destDir) throws MojoExecutionException {
        int index;
        String[] oldFiles = FileUtils.getFilesFromExtension((String)destDir.getAbsolutePath(), (String[])new String[]{"jar"});
        for (index = 0; index < oldFiles.length; ++index) {
            if (new File(oldFiles[index]).delete()) continue;
            this.log.error((CharSequence)Messages.getString("Rad6LibCopier.cantdeletefile", new Object[]{oldFiles[index]}));
        }
        for (index = 0; index < deps.length; ++index) {
            if (deps[index].isTestDependency() || deps[index].isProvided() || deps[index].isReferencedProject() || deps[index].isSystemScoped()) continue;
            this.copyFile(deps[index].getFile(), new File(destDir, deps[index].getFile().getName()), this.log);
        }
    }

    private void copyFile(File artifact, File destFile, Log log) throws MojoExecutionException {
        try {
            log.info((CharSequence)("Copying " + artifact.getAbsolutePath() + " to " + destFile));
            FileUtils.copyFile((File)artifact, (File)destFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, (Exception)e);
        }
    }

    private void handleEarLibs(IdeDependency[] deps) throws MojoExecutionException {
        File targetDir = this.config.getProject().getBasedir();
        this.copyArtifact(deps, targetDir);
    }

    private void handleWarLibs(IdeDependency[] deps) throws MojoExecutionException {
        File basedir = this.config.getProject().getBasedir();
        File warSourceDirectory = new File(IdeUtils.getPluginSetting(this.config.getProject(), "org.apache.maven.plugins:maven-war-plugin", "warSourceDirectory", "src/main/webapp"));
        String webContentDir = IdeUtils.toRelativeAndFixSeparator(this.config.getEclipseProjectDirectory(), warSourceDirectory, false);
        String srcMainWebappWebInfLibDirName = basedir.getAbsolutePath() + File.separatorChar + webContentDir + File.separatorChar + "WEB-INF" + File.separatorChar + "lib";
        File srcMainWebappWebInfLibDir = new File(srcMainWebappWebInfLibDirName);
        srcMainWebappWebInfLibDir.mkdirs();
        this.copyArtifact(deps, srcMainWebappWebInfLibDir);
    }
}

