/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.xml.build.io.xpp3;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.maven.buildcache.xml.build.Artifact;
import org.apache.maven.buildcache.xml.build.Build;
import org.apache.maven.buildcache.xml.build.CompletedExecution;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.buildcache.xml.build.PropertyValue;
import org.apache.maven.buildcache.xml.build.Scm;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class BuildCacheBuildXpp3Reader {
    private boolean addDefaultEntities = true;
    public final ContentTransformer contentTransformer;

    public BuildCacheBuildXpp3Reader() {
        this(new ContentTransformer(){

            @Override
            public String transform(String source, String fieldName) {
                return source;
            }
        });
    }

    public BuildCacheBuildXpp3Reader(ContentTransformer contentTransformer) {
        this.contentTransformer = contentTransformer;
    }

    private boolean checkFieldWithDuplicate(XmlPullParser parser, String tagName, String alias, Set parsed) throws XmlPullParserException {
        if (!parser.getName().equals(tagName) && !parser.getName().equals(alias)) {
            return false;
        }
        if (!parsed.add(tagName)) {
            throw new XmlPullParserException("Duplicated tag: '" + tagName + "'", parser, null);
        }
        return true;
    }

    private void checkUnknownAttribute(XmlPullParser parser, String attribute, String tagName, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null);
        }
    }

    private void checkUnknownElement(XmlPullParser parser, boolean strict) throws XmlPullParserException, IOException {
        if (strict) {
            throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", parser, null);
        }
        int unrecognizedTagCount = 1;
        while (unrecognizedTagCount > 0) {
            int eventType = parser.next();
            if (eventType == 2) {
                ++unrecognizedTagCount;
                continue;
            }
            if (eventType != 3) continue;
            --unrecognizedTagCount;
        }
    }

    public boolean getAddDefaultEntities() {
        return this.addDefaultEntities;
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getBooleanValue(s, attribute, parser, null);
    }

    private boolean getBooleanValue(String s, String attribute, XmlPullParser parser, String defaultValue) throws XmlPullParserException {
        if (s != null && s.length() != 0) {
            return Boolean.valueOf(s);
        }
        if (defaultValue != null) {
            return Boolean.valueOf(defaultValue);
        }
        return false;
    }

    private byte getByteValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Byte.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a byte", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private char getCharacterValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            return s.charAt(0);
        }
        return '\u0000';
    }

    private Date getDateValue(String s, String attribute, XmlPullParser parser) throws XmlPullParserException {
        return this.getDateValue(s, attribute, null, parser);
    }

    private Date getDateValue(String s, String attribute, String dateFormat, XmlPullParser parser) throws XmlPullParserException {
        if (s != null) {
            String effectiveDateFormat = dateFormat;
            if (dateFormat == null) {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ("long".equals(effectiveDateFormat)) {
                try {
                    return new Date(Long.parseLong(s));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
                }
            }
            try {
                SimpleDateFormat dateParser = new SimpleDateFormat(effectiveDateFormat, Locale.US);
                return dateParser.parse(s);
            }
            catch (ParseException e) {
                throw new XmlPullParserException(e.getMessage(), parser, (Throwable)e);
            }
        }
        return null;
    }

    private double getDoubleValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Double.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0;
    }

    private float getFloatValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Float.valueOf(s).floatValue();
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a floating point number", parser, (Throwable)nfe);
                }
            }
        }
        return 0.0f;
    }

    private int getIntegerValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Integer.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be an integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private long getLongValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a long integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0L;
    }

    private String getRequiredAttributeValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        if (s == null && strict) {
            throw new XmlPullParserException("Missing required value for attribute '" + attribute + "'", parser, null);
        }
        return s;
    }

    private short getShortValue(String s, String attribute, XmlPullParser parser, boolean strict) throws XmlPullParserException {
        block3: {
            if (s != null) {
                try {
                    return Short.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    if (!strict) break block3;
                    throw new XmlPullParserException("Unable to parse element '" + attribute + "', must be a short integer", parser, (Throwable)nfe);
                }
            }
        }
        return 0;
    }

    private String getTrimmedValue(String s) {
        if (s != null) {
            s = s.trim();
        }
        return s;
    }

    private String interpolatedTrimmed(String value, String context) {
        return this.getTrimmedValue(this.contentTransformer.transform(value, context));
    }

    private int nextTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int eventType = parser.next();
        if (eventType == 4) {
            eventType = parser.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null);
        }
        return eventType;
    }

    public Build read(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        Build build = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while (eventType != 1) {
            if (eventType == 2) {
                if (strict && !"build".equals(parser.getName())) {
                    throw new XmlPullParserException("Expected root element 'build' but found '" + parser.getName() + "'", parser, null);
                }
                if (parsed) {
                    throw new XmlPullParserException("Duplicated tag: 'build'", parser, null);
                }
                build = this.parseBuild(parser, strict);
                build.setModelEncoding(parser.getInputEncoding());
                parsed = true;
            }
            eventType = parser.next();
        }
        if (parsed) {
            return build;
        }
        throw new XmlPullParserException("Expected root element 'build' but found no element at all: invalid XML document", parser, null);
    }

    public Build read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
        MXParser parser = this.addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser();
        parser.setInput(reader);
        return this.read((XmlPullParser)parser, strict);
    }

    public Build read(Reader reader) throws IOException, XmlPullParserException {
        return this.read(reader, true);
    }

    public Build read(InputStream in, boolean strict) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in), strict);
    }

    public Build read(InputStream in) throws IOException, XmlPullParserException {
        return this.read((Reader)ReaderFactory.newXmlReader((InputStream)in));
    }

    private Artifact parseArtifact(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Artifact artifact = new Artifact();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "groupId", null, parsed)) {
                artifact.setGroupId(this.interpolatedTrimmed(parser.nextText(), "groupId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifactId", null, parsed)) {
                artifact.setArtifactId(this.interpolatedTrimmed(parser.nextText(), "artifactId"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "version", null, parsed)) {
                artifact.setVersion(this.interpolatedTrimmed(parser.nextText(), "version"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "classifier", null, parsed)) {
                artifact.setClassifier(this.interpolatedTrimmed(parser.nextText(), "classifier"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "type", null, parsed)) {
                artifact.setType(this.interpolatedTrimmed(parser.nextText(), "type"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scope", null, parsed)) {
                artifact.setScope(this.interpolatedTrimmed(parser.nextText(), "scope"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileName", null, parsed)) {
                artifact.setFileName(this.interpolatedTrimmed(parser.nextText(), "fileName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileHash", null, parsed)) {
                artifact.setFileHash(this.interpolatedTrimmed(parser.nextText(), "fileHash"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "fileSize", null, parsed)) {
                artifact.setFileSize(this.getLongValue(this.interpolatedTrimmed(parser.nextText(), "fileSize"), "fileSize", parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "filePath", null, parsed)) {
                artifact.setFilePath(this.interpolatedTrimmed(parser.nextText(), "filePath"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return artifact;
    }

    private Build parseBuild(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Build build = new Build();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0 || "xmlns".equals(name)) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "cacheImplementationVersion", null, parsed)) {
                build.setCacheImplementationVersion(this.interpolatedTrimmed(parser.nextText(), "cacheImplementationVersion"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "final", "final", parsed)) {
                build.set_final(this.getBooleanValue(this.interpolatedTrimmed(parser.nextText(), "final"), "final", parser, "null"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "hashFunction", null, parsed)) {
                build.setHashFunction(this.interpolatedTrimmed(parser.nextText(), "hashFunction"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "buildTime", null, parsed)) {
                String dateFormat = null;
                build.setBuildTime(this.getDateValue(this.interpolatedTrimmed(parser.nextText(), "buildTime"), "buildTime", dateFormat, parser));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "buildServer", null, parsed)) {
                build.setBuildServer(this.interpolatedTrimmed(parser.nextText(), "buildServer"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "scm", null, parsed)) {
                build.setScm(this.parseScm(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "goals", null, parsed)) {
                ArrayList<String> goals = new ArrayList<String>();
                while (parser.nextTag() == 2) {
                    if ("goal".equals(parser.getName())) {
                        goals.add(this.interpolatedTrimmed(parser.nextText(), "goals"));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                build.setGoals(goals);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "artifact", null, parsed)) {
                build.setArtifact(this.parseArtifact(parser, strict));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "attachedArtifacts", null, parsed)) {
                ArrayList<Artifact> attachedArtifacts = new ArrayList<Artifact>();
                while (parser.nextTag() == 2) {
                    if ("attachedArtifact".equals(parser.getName())) {
                        attachedArtifacts.add(this.parseArtifact(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                build.setAttachedArtifacts(attachedArtifacts);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "executions", null, parsed)) {
                ArrayList<CompletedExecution> executions = new ArrayList<CompletedExecution>();
                while (parser.nextTag() == 2) {
                    if ("execution".equals(parser.getName())) {
                        executions.add(this.parseCompletedExecution(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                build.setExecutions(executions);
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "projectsInputInfo", null, parsed)) {
                build.setProjectsInputInfo(this.parseProjectsInputInfo(parser, strict));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return build;
    }

    private CompletedExecution parseCompletedExecution(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        CompletedExecution completedExecution = new CompletedExecution();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "executionKey", null, parsed)) {
                completedExecution.setExecutionKey(this.interpolatedTrimmed(parser.nextText(), "executionKey"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "mojoClassName", null, parsed)) {
                completedExecution.setMojoClassName(this.interpolatedTrimmed(parser.nextText(), "mojoClassName"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "properties", null, parsed)) {
                ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
                while (parser.nextTag() == 2) {
                    if ("property".equals(parser.getName())) {
                        properties.add(this.parsePropertyValue(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                completedExecution.setProperties(properties);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return completedExecution;
    }

    private DigestItem parseDigestItem(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        DigestItem digestItem = new DigestItem();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("type".equals(name)) {
                digestItem.setType(this.interpolatedTrimmed(value, "type"));
                continue;
            }
            if ("hash".equals(name)) {
                digestItem.setHash(this.interpolatedTrimmed(value, "hash"));
                continue;
            }
            if ("fileChecksum".equals(name)) {
                digestItem.setFileChecksum(this.interpolatedTrimmed(value, "fileChecksum"));
                continue;
            }
            if ("content".equals(name)) {
                digestItem.setContent(this.interpolatedTrimmed(value, "content"));
                continue;
            }
            if ("isText".equals(name)) {
                digestItem.setIsText(this.interpolatedTrimmed(value, "isText"));
                continue;
            }
            if ("charset".equals(name)) {
                digestItem.setCharset(this.interpolatedTrimmed(value, "charset"));
                continue;
            }
            if ("eol".equals(name)) {
                digestItem.setEol(this.interpolatedTrimmed(value, "eol"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        digestItem.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
        return digestItem;
    }

    private ProjectsInputInfo parseProjectsInputInfo(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        ProjectsInputInfo projectsInputInfo = new ProjectsInputInfo();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "checksum", null, parsed)) {
                projectsInputInfo.setChecksum(this.interpolatedTrimmed(parser.nextText(), "checksum"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "items", null, parsed)) {
                ArrayList<DigestItem> items = new ArrayList<DigestItem>();
                while (parser.nextTag() == 2) {
                    if ("item".equals(parser.getName())) {
                        items.add(this.parseDigestItem(parser, strict));
                        continue;
                    }
                    this.checkUnknownElement(parser, strict);
                }
                projectsInputInfo.setItems(items);
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return projectsInputInfo;
    }

    private PropertyValue parsePropertyValue(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        PropertyValue propertyValue = new PropertyValue();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            if ("name".equals(name)) {
                propertyValue.setName(this.interpolatedTrimmed(value, "name"));
                continue;
            }
            if ("tracked".equals(name)) {
                propertyValue.setTracked(this.getBooleanValue(this.interpolatedTrimmed(value, "tracked"), "tracked", parser, "null"));
                continue;
            }
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        propertyValue.setValue(this.interpolatedTrimmed(parser.nextText(), "value"));
        return propertyValue;
    }

    private Scm parseScm(XmlPullParser parser, boolean strict) throws IOException, XmlPullParserException {
        String tagName = parser.getName();
        Scm scm = new Scm();
        for (int i = parser.getAttributeCount() - 1; i >= 0; --i) {
            String name = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if (name.indexOf(58) >= 0) continue;
            this.checkUnknownAttribute(parser, name, tagName, strict);
        }
        HashSet parsed = new HashSet();
        while ((strict ? parser.nextTag() : this.nextTag(parser)) == 2) {
            if (this.checkFieldWithDuplicate(parser, "sourceBranch", null, parsed)) {
                scm.setSourceBranch(this.interpolatedTrimmed(parser.nextText(), "sourceBranch"));
                continue;
            }
            if (this.checkFieldWithDuplicate(parser, "revision", null, parsed)) {
                scm.setRevision(this.interpolatedTrimmed(parser.nextText(), "revision"));
                continue;
            }
            this.checkUnknownElement(parser, strict);
        }
        return scm;
    }

    public void setAddDefaultEntities(boolean addDefaultEntities) {
        this.addDefaultEntities = addDefaultEntities;
    }

    public static interface ContentTransformer {
        public String transform(String var1, String var2);
    }
}

