/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class MojoParametersListener
implements MojoExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MojoParametersListener.class);
    private final ConcurrentMap<MavenProject, Map<String, MojoExecutionEvent>> projectExecutions = new ConcurrentHashMap<MavenProject, Map<String, MojoExecutionEvent>>();

    public void beforeMojoExecution(MojoExecutionEvent event) {
        ConcurrentHashMap<String, MojoExecutionEvent> candidate;
        String executionKey = CacheUtils.mojoExecutionKey(event.getExecution());
        LOGGER.debug("Starting mojo execution: {}, class: {}", (Object)executionKey, event.getMojo().getClass());
        MavenProject project = event.getProject();
        ConcurrentHashMap<String, MojoExecutionEvent> projectEvents = (ConcurrentHashMap<String, MojoExecutionEvent>)this.projectExecutions.get(project);
        if (projectEvents == null && (projectEvents = (Map)this.projectExecutions.putIfAbsent(project, candidate = new ConcurrentHashMap<String, MojoExecutionEvent>())) == null) {
            projectEvents = candidate;
        }
        projectEvents.put(executionKey, event);
    }

    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
    }

    public void afterExecutionFailure(MojoExecutionEvent event) {
    }

    public Map<String, MojoExecutionEvent> getProjectExecutions(MavenProject project) {
        return (Map)this.projectExecutions.get(project);
    }

    public void remove(MavenProject project) {
        this.projectExecutions.remove(project);
    }
}

