/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.Objects;
import org.apache.maven.buildcache.CacheContext;
import org.apache.maven.buildcache.RestoreStatus;
import org.apache.maven.buildcache.xml.Build;
import org.apache.maven.buildcache.xml.CacheSource;

public class CacheResult {
    private final RestoreStatus status;
    private final Build build;
    private final CacheContext context;

    private CacheResult(RestoreStatus status, Build build, CacheContext context) {
        this.status = Objects.requireNonNull(status);
        this.build = build;
        this.context = context;
    }

    public static CacheResult empty(CacheContext context) {
        Objects.requireNonNull(context);
        return new CacheResult(RestoreStatus.EMPTY, null, context);
    }

    public static CacheResult empty() {
        return new CacheResult(RestoreStatus.EMPTY, null, null);
    }

    public static CacheResult failure(Build build, CacheContext context) {
        Objects.requireNonNull(build);
        Objects.requireNonNull(context);
        return new CacheResult(RestoreStatus.FAILURE, build, context);
    }

    public static CacheResult success(Build build, CacheContext context) {
        Objects.requireNonNull(build);
        Objects.requireNonNull(context);
        return new CacheResult(RestoreStatus.SUCCESS, build, context);
    }

    public static CacheResult partialSuccess(Build build, CacheContext context) {
        Objects.requireNonNull(build);
        Objects.requireNonNull(context);
        return new CacheResult(RestoreStatus.PARTIAL, build, context);
    }

    public static CacheResult failure(CacheContext context) {
        Objects.requireNonNull(context);
        return new CacheResult(RestoreStatus.FAILURE, null, context);
    }

    public static CacheResult rebuilded(CacheResult orig, Build build) {
        Objects.requireNonNull(orig);
        Objects.requireNonNull(build);
        return new CacheResult(orig.status, build, orig.context);
    }

    public boolean isSuccess() {
        return this.status == RestoreStatus.SUCCESS;
    }

    public Build getBuildInfo() {
        return this.build;
    }

    public CacheSource getSource() {
        return this.build != null ? this.build.getSource() : null;
    }

    public CacheContext getContext() {
        return this.context;
    }

    public boolean isPartialSuccess() {
        return this.status == RestoreStatus.PARTIAL;
    }

    public RestoreStatus getStatus() {
        return this.status;
    }

    public boolean isFinal() {
        return this.build != null && this.build.getDto().is_final() != false;
    }
}

