/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.CacheController;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.execution.MavenSession;

@SessionScoped
@Named
public class CacheLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private final CacheConfig cacheConfig;
    private final CacheController cacheController;

    @Inject
    public CacheLifecycleParticipant(CacheConfig cacheConfig, CacheController cacheController) {
        this.cacheConfig = cacheConfig;
        this.cacheController = cacheController;
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        if (this.cacheConfig.isEnabled()) {
            this.cacheController.saveCacheReport(session);
        }
    }
}

