/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.SessionScoped;
import org.apache.maven.buildcache.CacheController;
import org.apache.maven.buildcache.CacheResult;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.LifecyclePhasesHelper;
import org.apache.maven.buildcache.MojoParametersListener;
import org.apache.maven.buildcache.checksum.KeyUtils;
import org.apache.maven.buildcache.checksum.MavenProjectInput;
import org.apache.maven.buildcache.xml.Build;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.CacheState;
import org.apache.maven.buildcache.xml.DtoUtils;
import org.apache.maven.buildcache.xml.build.CompletedExecution;
import org.apache.maven.buildcache.xml.config.TrackedProperty;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionRunner;
import org.apache.maven.plugin.MojosExecutionStrategy;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
@Named
@Priority(value=10)
public class BuildCacheMojosExecutionStrategy
implements MojosExecutionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildCacheMojosExecutionStrategy.class);
    private final CacheController cacheController;
    private final CacheConfig cacheConfig;
    private final MojoParametersListener mojoListener;
    private final LifecyclePhasesHelper lifecyclePhasesHelper;
    private final MavenPluginManager mavenPluginManager;

    @Inject
    public BuildCacheMojosExecutionStrategy(CacheController cacheController, CacheConfig cacheConfig, MojoParametersListener mojoListener, LifecyclePhasesHelper lifecyclePhasesHelper, MavenPluginManager mavenPluginManager) {
        this.cacheController = cacheController;
        this.cacheConfig = cacheConfig;
        this.mojoListener = mojoListener;
        this.lifecyclePhasesHelper = lifecyclePhasesHelper;
        this.mavenPluginManager = mavenPluginManager;
    }

    public void execute(List<MojoExecution> mojoExecutions, MavenSession session, MojoExecutionRunner mojoExecutionRunner) throws LifecycleExecutionException {
        MavenProject project = session.getCurrentProject();
        MojoExecution.Source source = this.getSource(mojoExecutions);
        CacheState cacheState = CacheState.DISABLED;
        CacheResult result = CacheResult.empty();
        boolean skipCache = this.cacheConfig.isSkipCache() || MavenProjectInput.isSkipCache(project);
        boolean cacheIsDisabled = MavenProjectInput.isCacheDisabled(project);
        boolean forkedExecution = this.lifecyclePhasesHelper.isForkedProject(project);
        if (source == MojoExecution.Source.LIFECYCLE && !forkedExecution) {
            List<MojoExecution> cleanPhase = this.lifecyclePhasesHelper.getCleanSegment(project, mojoExecutions);
            for (MojoExecution mojoExecution : cleanPhase) {
                mojoExecutionRunner.run(mojoExecution);
            }
            if (!cacheIsDisabled) {
                cacheState = this.cacheConfig.initialize();
            } else {
                LOGGER.info("Cache is explicitly disabled on project level for {}", (Object)KeyUtils.getVersionlessProjectKey(project));
            }
            if (cacheState == CacheState.INITIALIZED || skipCache) {
                result = this.cacheController.findCachedBuild(session, project, mojoExecutions, skipCache);
            }
        }
        boolean restorable = result.isSuccess() || result.isPartialSuccess();
        boolean restored = result.isSuccess();
        if (restorable) {
            restored &= this.restoreProject(result, mojoExecutions, mojoExecutionRunner, this.cacheConfig);
        } else {
            for (MojoExecution mojoExecution : mojoExecutions) {
                if (source != MojoExecution.Source.CLI && mojoExecution.getLifecyclePhase() != null && !this.lifecyclePhasesHelper.isLaterPhaseThanClean(mojoExecution.getLifecyclePhase())) continue;
                mojoExecutionRunner.run(mojoExecution);
            }
        }
        if (!(cacheState != CacheState.INITIALIZED || restorable && restored)) {
            Map<String, MojoExecutionEvent> executionEvents = this.mojoListener.getProjectExecutions(project);
            this.cacheController.save(result, mojoExecutions, executionEvents);
        }
        if (this.cacheConfig.isFailFast() && !result.isSuccess() && !skipCache && !forkedExecution) {
            throw new LifecycleExecutionException("Failed to restore project[" + KeyUtils.getVersionlessProjectKey(project) + "] from cache, failing build.", project);
        }
    }

    private MojoExecution.Source getSource(List<MojoExecution> mojoExecutions) {
        if (mojoExecutions == null || mojoExecutions.isEmpty()) {
            return null;
        }
        for (MojoExecution mojoExecution : mojoExecutions) {
            if (mojoExecution.getSource() != MojoExecution.Source.CLI) continue;
            return MojoExecution.Source.CLI;
        }
        return MojoExecution.Source.LIFECYCLE;
    }

    private boolean restoreProject(CacheResult cacheResult, List<MojoExecution> mojoExecutions, MojoExecutionRunner mojoExecutionRunner, CacheConfig cacheConfig) throws LifecycleExecutionException {
        Build build = cacheResult.getBuildInfo();
        MavenProject project = cacheResult.getContext().getProject();
        MavenSession session = cacheResult.getContext().getSession();
        List<MojoExecution> cachedSegment = this.lifecyclePhasesHelper.getCachedSegment(project, mojoExecutions, build);
        boolean restored = this.cacheController.restoreProjectArtifacts(cacheResult);
        if (!restored) {
            LOGGER.info("Cannot restore project artifacts, continuing with non cached build");
            return false;
        }
        for (MojoExecution cacheCandidate : cachedSegment) {
            if (this.cacheController.isForcedExecution(project, cacheCandidate)) {
                LOGGER.info("Mojo execution is forced by project property: {}", (Object)cacheCandidate.getMojoDescriptor().getFullGoalName());
                mojoExecutionRunner.run(cacheCandidate);
                continue;
            }
            restored = this.verifyCacheConsistency(cacheCandidate, build, project, session, mojoExecutionRunner, cacheConfig);
            if (restored) continue;
            break;
        }
        if (!restored) {
            project.getArtifact().setFile(null);
            project.getArtifact().setResolved(false);
            this.mojoListener.remove(project);
            for (MojoExecution mojoExecution : cachedSegment) {
                mojoExecutionRunner.run(mojoExecution);
            }
        }
        List<MojoExecution> postCachedSegment = this.lifecyclePhasesHelper.getPostCachedSegment(project, mojoExecutions, build);
        for (MojoExecution mojoExecution : postCachedSegment) {
            mojoExecutionRunner.run(mojoExecution);
        }
        return restored;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyCacheConsistency(MojoExecution cacheCandidate, Build cachedBuild, MavenProject project, MavenSession session, MojoExecutionRunner mojoExecutionRunner, CacheConfig cacheConfig) throws LifecycleExecutionException {
        long createdTimestamp = System.currentTimeMillis();
        boolean consistent = true;
        if (!cacheConfig.getTrackedProperties(cacheCandidate).isEmpty()) {
            Mojo mojo = null;
            try {
                mojo = (Mojo)this.mavenPluginManager.getConfiguredMojo(Mojo.class, session, cacheCandidate);
                CompletedExecution completedExecution = cachedBuild.findMojoExecutionInfo(cacheCandidate);
                String fullGoalName = cacheCandidate.getMojoDescriptor().getFullGoalName();
                if (completedExecution != null && !this.isParamsMatched(project, cacheCandidate, mojo, completedExecution)) {
                    LOGGER.info("Mojo cached parameters mismatch with actual, forcing full project build. Mojo: {}", (Object)fullGoalName);
                    consistent = false;
                }
                if (consistent) {
                    long elapsed = System.currentTimeMillis() - createdTimestamp;
                    LOGGER.info("Skipping plugin execution (reconciled in {} millis): {}", (Object)elapsed, (Object)fullGoalName);
                }
                if (!LOGGER.isDebugEnabled()) return consistent;
                LOGGER.debug("Checked {}, resolved mojo: {}, cached params: {}", new Object[]{fullGoalName, mojo, completedExecution});
                return consistent;
            }
            catch (PluginConfigurationException | PluginContainerException e) {
                throw new LifecycleExecutionException("Cannot get configured mojo", e);
            }
            finally {
                if (mojo != null) {
                    this.mavenPluginManager.releaseMojo((Object)mojo, cacheCandidate);
                }
            }
        } else {
            LOGGER.info("Skipping plugin execution (cached): {}", (Object)cacheCandidate.getMojoDescriptor().getFullGoalName());
        }
        return consistent;
    }

    boolean isParamsMatched(MavenProject project, MojoExecution mojoExecution, Mojo mojo, CompletedExecution completedExecution) {
        List<TrackedProperty> tracked = this.cacheConfig.getTrackedProperties(mojoExecution);
        for (TrackedProperty trackedProperty : tracked) {
            String currentValue;
            String propertyName = trackedProperty.getPropertyName();
            String expectedValue = DtoUtils.findPropertyValue(propertyName, completedExecution);
            if (expectedValue == null) {
                expectedValue = trackedProperty.getDefaultValue() != null ? trackedProperty.getDefaultValue() : "null";
            }
            try {
                Path baseDirPath;
                Object value = ReflectionUtils.getValueIncludingSuperclasses((String)propertyName, (Object)mojo);
                if (value instanceof File) {
                    baseDirPath = project.getBasedir().toPath();
                    Path path = ((File)value).toPath();
                    currentValue = BuildCacheMojosExecutionStrategy.normalizedPath(path, baseDirPath);
                } else if (value instanceof Path) {
                    baseDirPath = project.getBasedir().toPath();
                    currentValue = BuildCacheMojosExecutionStrategy.normalizedPath((Path)value, baseDirPath);
                } else {
                    currentValue = value != null && value.getClass().isArray() ? ArrayUtils.toString((Object)value) : String.valueOf(value);
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Cannot extract plugin property {} from mojo {}", new Object[]{propertyName, mojo, e});
                return false;
            }
            if (StringUtils.equals((CharSequence)currentValue, (CharSequence)expectedValue)) continue;
            if (!StringUtils.equals((CharSequence)currentValue, (CharSequence)trackedProperty.getSkipValue())) {
                LOGGER.info("Plugin parameter mismatch found. Parameter: {}, expected: {}, actual: {}", new Object[]{propertyName, expectedValue, currentValue});
                return false;
            }
            LOGGER.warn("Cache contains plugin execution with skip flag and might be incomplete. Property: {}, execution {}", (Object)propertyName, (Object)CacheUtils.mojoExecutionKey(mojoExecution));
        }
        return true;
    }

    private static String normalizedPath(Path path, Path baseDirPath) {
        boolean isProjectSubdir;
        boolean bl = isProjectSubdir = path.isAbsolute() && path.startsWith(baseDirPath);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("normalizedPath isProjectSubdir {} path '{}' - baseDirPath '{}', path.isAbsolute() {}, path.startsWith(baseDirPath) {}", new Object[]{isProjectSubdir, path, baseDirPath, path.isAbsolute(), path.startsWith(baseDirPath)});
        }
        Path preparedPath = isProjectSubdir ? baseDirPath.relativize(path) : path;
        String normalizedPath = preparedPath.normalize().toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("normalizedPath '{}' - {} return {}", new Object[]{path, baseDirPath, normalizedPath});
        }
        return normalizedPath;
    }
}

