/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.TopOrdAndNumberQueue;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.ParallelTaxonomyArrays;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntIntHashMap;
import org.apache.lucene.util.PriorityQueue;

abstract class TaxonomyFacets
extends Facets {
    final String indexFieldName;
    final TaxonomyReader taxoReader;
    final FacetsConfig config;
    final FacetsCollector fc;
    private ParallelTaxonomyArrays.IntArray children;
    private ParallelTaxonomyArrays.IntArray siblings;
    final ParallelTaxonomyArrays.IntArray parents;
    int[] counts;
    IntIntHashMap sparseCounts;
    boolean initialized;
    protected Comparator<Number> valueComparator;

    TaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        this.indexFieldName = indexFieldName;
        this.taxoReader = taxoReader;
        this.config = config;
        this.fc = fc;
        this.parents = taxoReader.getParallelTaxonomyArrays().parents();
        this.valueComparator = Comparator.comparingInt(x -> (Integer)x);
    }

    private boolean useHashTable(FacetsCollector fc, TaxonomyReader taxoReader) {
        if (taxoReader.getSize() < 1024) {
            return false;
        }
        if (fc == null) {
            return false;
        }
        int maxDoc = 0;
        int sumTotalHits = 0;
        for (FacetsCollector.MatchingDocs docs : fc.getMatchingDocs()) {
            sumTotalHits += docs.totalHits();
            maxDoc += docs.context().reader().maxDoc();
        }
        return sumTotalHits < maxDoc / 10;
    }

    protected void initializeValueCounters() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        assert (this.sparseCounts == null && this.counts == null);
        if (this.useHashTable(this.fc, this.taxoReader)) {
            this.sparseCounts = new IntIntHashMap();
        } else {
            this.counts = new int[this.taxoReader.getSize()];
        }
    }

    protected void setCount(int ordinal, int newValue) {
        if (this.sparseCounts != null) {
            this.sparseCounts.put(ordinal, newValue);
        } else {
            this.counts[ordinal] = newValue;
        }
    }

    protected int getCount(int ordinal) {
        if (this.sparseCounts != null) {
            return this.sparseCounts.get(ordinal);
        }
        return this.counts[ordinal];
    }

    protected Number getAggregationValue(int ordinal) {
        return this.getCount(ordinal);
    }

    protected Number aggregate(Number existingVal, Number newVal) {
        return (Integer)existingVal + (Integer)newVal;
    }

    boolean hasValues() {
        return this.initialized;
    }

    ParallelTaxonomyArrays.IntArray getChildren() throws IOException {
        if (this.children == null) {
            this.children = this.taxoReader.getParallelTaxonomyArrays().children();
        }
        return this.children;
    }

    ParallelTaxonomyArrays.IntArray getSiblings() throws IOException {
        if (this.siblings == null) {
            this.siblings = this.taxoReader.getParallelTaxonomyArrays().siblings();
        }
        return this.siblings;
    }

    public boolean childrenLoaded() {
        return this.children != null;
    }

    public boolean siblingsLoaded() {
        return this.siblings != null;
    }

    FacetsConfig.DimConfig verifyDim(String dim) {
        FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
        if (this.config.isDimConfigured(dim) && !dimConfig.indexFieldName.equals(this.indexFieldName)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "dimension \"%s\" cannot be found in field \"%s\", since it was configured to be indexed into field \"%s\"", dim, this.indexFieldName, dimConfig.indexFieldName));
        }
        return dimConfig;
    }

    protected void updateValueFromRollup(int ordinal, int childOrdinal) throws IOException {
        this.setCount(ordinal, this.getCount(ordinal) + this.rollup(childOrdinal));
    }

    protected TopOrdAndNumberQueue makeTopOrdAndNumberQueue(int topN) {
        return new TopOrdAndIntQueue(Math.min(this.taxoReader.getSize(), topN));
    }

    protected Number missingAggregationValue() {
        return -1;
    }

    void rollup() throws IOException {
        if (!this.initialized) {
            return;
        }
        ParallelTaxonomyArrays.IntArray children = null;
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            int dimRootOrd;
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued || (dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim))) <= 0) continue;
            if (children == null) {
                children = this.getChildren();
            }
            this.updateValueFromRollup(dimRootOrd, children.get(dimRootOrd));
        }
    }

    private int rollup(int ord) throws IOException {
        ParallelTaxonomyArrays.IntArray children = this.getChildren();
        ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
        int aggregatedValue = 0;
        while (ord != -1) {
            int currentValue = this.getCount(ord);
            int newValue = currentValue + this.rollup(children.get(ord));
            this.setCount(ord, newValue);
            aggregatedValue += this.getCount(ord);
            ord = siblings.get(ord);
        }
        return aggregatedValue;
    }

    private FacetResult createFacetResult(TopChildrenForPath topChildrenForPath, String dim, String ... path) throws IOException {
        if (topChildrenForPath == null || topChildrenForPath.childCount == 0) {
            return null;
        }
        TopOrdAndNumberQueue q = topChildrenForPath.childQueue;
        assert (q != null);
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        int[] ordinals = new int[labelValues.length];
        Number[] values = new Number[labelValues.length];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndNumberQueue.OrdAndValue ordAndValue = (TopOrdAndNumberQueue.OrdAndValue)q.pop();
            assert (ordAndValue != null);
            ordinals[i] = ordAndValue.ord;
            values[i] = ordAndValue.getValue();
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals);
        int childComponentIdx = path.length + 1;
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[childComponentIdx], values[i], this.getCount(ordinals[i]));
        }
        return new FacetResult(dim, path, topChildrenForPath.pathValue, labelValues, topChildrenForPath.childCount);
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        if (!this.initialized) {
            return null;
        }
        Number aggregatedValue = 0;
        int aggregatedCount = 0;
        IntArrayList ordinals = new IntArrayList();
        ArrayList<Number> ordValues = new ArrayList<Number>();
        if (this.sparseCounts != null) {
            for (IntIntHashMap.IntIntCursor ordAndCount : this.sparseCounts) {
                ord = ordAndCount.key;
                count = ordAndCount.value;
                value = this.getAggregationValue(ord);
                if (this.parents.get(ord) != dimOrd || count <= 0) continue;
                aggregatedCount += count;
                aggregatedValue = this.aggregate(aggregatedValue, value);
                ordinals.add(ord);
                ordValues.add(value);
            }
        } else {
            ParallelTaxonomyArrays.IntArray children = this.getChildren();
            ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
            ord = children.get(dimOrd);
            while (ord != -1) {
                count = this.counts[ord];
                value = this.getAggregationValue(ord);
                if (count > 0) {
                    aggregatedCount += count;
                    aggregatedValue = this.aggregate(aggregatedValue, value);
                    ordinals.add(ord);
                    ordValues.add(value);
                }
                ord = siblings.get(ord);
            }
        }
        if (aggregatedCount == 0) {
            return null;
        }
        if (dimConfig.multiValued) {
            aggregatedValue = dimConfig.requireDimCount ? (Number)this.getAggregationValue(dimOrd) : (Number)this.missingAggregationValue();
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals.toArray());
        LabelAndValue[] labelValues = new LabelAndValue[ordValues.size()];
        for (int i = 0; i < ordValues.size(); ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[cp.length], (Number)ordValues.get(i), this.getCount(ordinals.get(i)));
        }
        return new FacetResult(dim, path, aggregatedValue, labelValues, ordinals.size());
    }

    protected void setIncomingValue(TopOrdAndNumberQueue.OrdAndValue incomingOrdAndValue, int ord) {
        ((TopOrdAndIntQueue.OrdAndInt)incomingOrdAndValue).value = this.getCount(ord);
    }

    protected TopOrdAndNumberQueue.OrdAndValue insertIntoQueue(TopOrdAndNumberQueue q, TopOrdAndNumberQueue.OrdAndValue incomingOrdAndValue, int ord) {
        if (incomingOrdAndValue == null) {
            incomingOrdAndValue = q.newOrdAndValue();
        }
        incomingOrdAndValue.ord = ord;
        this.setIncomingValue(incomingOrdAndValue, ord);
        incomingOrdAndValue = (TopOrdAndNumberQueue.OrdAndValue)q.insertWithOverflow(incomingOrdAndValue);
        return incomingOrdAndValue;
    }

    protected AggregatedValue newAggregatedValue() {
        return new AggregatedCount(0);
    }

    protected TopChildrenForPath getTopChildrenForPath(FacetsConfig.DimConfig dimConfig, int pathOrd, int topN) throws IOException {
        TopOrdAndNumberQueue q = this.makeTopOrdAndNumberQueue(topN);
        AggregatedValue aggregatedValue = this.newAggregatedValue();
        int childCount = 0;
        TopOrdAndNumberQueue.OrdAndValue incomingOrdAndValue = null;
        if (this.sparseCounts != null) {
            for (IntIntHashMap.IntIntCursor c : this.sparseCounts) {
                int ord = c.key;
                int count = c.value;
                if (this.parents.get(ord) != pathOrd || count <= 0) continue;
                aggregatedValue.aggregate(ord);
                ++childCount;
                incomingOrdAndValue = this.insertIntoQueue(q, incomingOrdAndValue, ord);
            }
        } else {
            ParallelTaxonomyArrays.IntArray children = this.getChildren();
            ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
            int ord = children.get(pathOrd);
            while (ord != -1) {
                int count = this.counts[ord];
                if (count > 0) {
                    aggregatedValue.aggregate(ord);
                    ++childCount;
                    incomingOrdAndValue = this.insertIntoQueue(q, incomingOrdAndValue, ord);
                }
                ord = siblings.get(ord);
            }
        }
        Number aggregatedValueNumber = aggregatedValue.get();
        if (dimConfig.multiValued) {
            aggregatedValueNumber = dimConfig.requireDimCount ? (Number)this.getAggregationValue(pathOrd) : (Number)this.missingAggregationValue();
        }
        return new TopChildrenForPath(aggregatedValueNumber, childCount, q);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        TaxonomyFacets.validateTopN(topN);
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        if (!this.initialized) {
            return null;
        }
        TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimOrd, topN);
        return this.createFacetResult(topChildrenForPath, dim, path);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return this.initialized ? (Number)this.getAggregationValue(ord) : (Number)0;
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        TaxonomyFacets.validateTopN(topN);
        if (!this.hasValues()) {
            return Collections.emptyList();
        }
        ParallelTaxonomyArrays.IntArray children = this.getChildren();
        ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
        int ord = children.get(0);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        while (ord != -1) {
            FacetResult result;
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName) && (result = this.getTopChildren(topN, dim, new String[0])) != null) {
                results.add(result);
            }
            ord = siblings.get(ord);
        }
        results.sort((a, b) -> {
            if (a.value.doubleValue() > b.value.doubleValue()) {
                return -1;
            }
            if (b.value.doubleValue() > a.value.doubleValue()) {
                return 1;
            }
            return a.dim.compareTo(b.dim);
        });
        return results;
    }

    @Override
    public List<FacetResult> getTopDims(int topNDims, int topNChildren) throws IOException {
        if (topNDims <= 0 || topNChildren <= 0) {
            throw new IllegalArgumentException("topN must be > 0");
        }
        if (!this.initialized) {
            return Collections.emptyList();
        }
        ParallelTaxonomyArrays.IntArray children = this.getChildren();
        ParallelTaxonomyArrays.IntArray siblings = this.getSiblings();
        PriorityQueue<DimValue> pq = new PriorityQueue<DimValue>(topNDims){

            protected boolean lessThan(DimValue a, DimValue b) {
                int comparison = TaxonomyFacets.this.valueComparator.compare(a.value, b.value);
                if (comparison < 0) {
                    return true;
                }
                if (comparison > 0) {
                    return false;
                }
                return a.dim.compareTo(b.dim) > 0;
            }
        };
        HashMap<String, TopChildrenForPath> intermediateResults = null;
        int ord = children.get(0);
        while (ord != -1) {
            FacetLabel cp;
            int dimOrd;
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName) && (dimOrd = this.taxoReader.getOrdinal(cp = new FacetLabel(dim))) != -1) {
                Number dimValue;
                if (dimConfig.multiValued) {
                    dimValue = dimConfig.requireDimCount ? (Number)this.getAggregationValue(dimOrd) : (Number)-1;
                } else {
                    TopChildrenForPath topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimOrd, topNChildren);
                    if (intermediateResults == null) {
                        intermediateResults = new HashMap<String, TopChildrenForPath>();
                    }
                    intermediateResults.put(dim, topChildrenForPath);
                    dimValue = topChildrenForPath.pathValue();
                }
                if (this.valueComparator.compare(dimValue, 0) != 0) {
                    if (pq.size() < topNDims) {
                        pq.add((Object)new DimValue(dim, dimOrd, dimValue));
                    } else if (this.valueComparator.compare(dimValue, ((DimValue)pq.top()).value) > 0 || this.valueComparator.compare(dimValue, ((DimValue)pq.top()).value) == 0 && dim.compareTo(((DimValue)pq.top()).dim) < 0) {
                        DimValue bottomDim = (DimValue)pq.top();
                        bottomDim.dim = dim;
                        bottomDim.value = dimValue;
                        pq.updateTop();
                    }
                }
            }
            ord = siblings.get(ord);
        }
        FacetResult[] results = new FacetResult[pq.size()];
        while (pq.size() > 0) {
            DimValue dimValue = (DimValue)pq.pop();
            assert (dimValue != null);
            String dim = dimValue.dim;
            TopChildrenForPath topChildrenForPath = null;
            if (intermediateResults != null) {
                topChildrenForPath = (TopChildrenForPath)intermediateResults.get(dim);
            }
            if (topChildrenForPath == null) {
                FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
                topChildrenForPath = this.getTopChildrenForPath(dimConfig, dimValue.dimOrd, topNChildren);
            }
            FacetResult facetResult = this.createFacetResult(topChildrenForPath, dim, new String[0]);
            assert (facetResult != null);
            results[pq.size()] = facetResult;
        }
        return Arrays.asList(results);
    }

    record TopChildrenForPath(Number pathValue, int childCount, TopOrdAndNumberQueue childQueue) {
    }

    private class AggregatedCount
    extends AggregatedValue {
        private int count;

        private AggregatedCount(int count) {
            this.count = count;
        }

        @Override
        public void aggregate(int ord) {
            this.count += TaxonomyFacets.this.getCount(ord);
        }

        @Override
        public Number get() {
            return this.count;
        }
    }

    protected static abstract class AggregatedValue {
        protected AggregatedValue() {
        }

        public abstract void aggregate(int var1);

        public abstract Number get();
    }

    private static class DimValue {
        String dim;
        int dimOrd;
        Number value;

        DimValue(String dim, int dimOrd, Number value) {
            this.dim = dim;
            this.dimOrd = dimOrd;
            this.value = value;
        }
    }
}

