/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene91;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene91.Lucene91HnswVectorsReader;
import org.apache.lucene.index.DocsWithFieldSet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.RandomAccessVectorValuesProducer;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphBuilder;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;

public final class Lucene91HnswVectorsWriter
extends KnnVectorsWriter {
    private final SegmentWriteState segmentWriteState;
    private final IndexOutput meta;
    private final IndexOutput vectorData;
    private final IndexOutput vectorIndex;
    private final int maxDoc;
    private final int maxConn;
    private final int beamWidth;
    private boolean finished;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene91HnswVectorsWriter(SegmentWriteState state, int maxConn, int beamWidth) throws IOException {
        this.maxConn = maxConn;
        this.beamWidth = beamWidth;
        assert (state.fieldInfos.hasVectorValues());
        this.segmentWriteState = state;
        String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
        String vectorDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vec");
        String indexDataFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vex");
        boolean success = false;
        try {
            this.meta = state.directory.createOutput(metaFileName, state.context);
            this.vectorData = state.directory.createOutput(vectorDataFileName, state.context);
            this.vectorIndex = state.directory.createOutput(indexDataFileName, state.context);
            CodecUtil.writeIndexHeader(this.meta, "Lucene91HnswVectorsFormatMeta", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorData, "Lucene91HnswVectorsFormatData", 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.writeIndexHeader(this.vectorIndex, "Lucene91HnswVectorsFormatIndex", 0, state.segmentInfo.getId(), state.segmentSuffix);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeField(FieldInfo fieldInfo, KnnVectorsReader knnVectorsReader) throws IOException {
        long vectorDataOffset = this.vectorData.alignFilePointer(4);
        VectorValues vectors = knnVectorsReader.getVectorValues(fieldInfo.name);
        IndexOutput tempVectorData = this.segmentWriteState.directory.createTempOutput(this.vectorData.getName(), "temp", this.segmentWriteState.context);
        IndexInput vectorDataInput = null;
        boolean success = false;
        try {
            DocsWithFieldSet docsWithField = Lucene91HnswVectorsWriter.writeVectorData(tempVectorData, vectors);
            CodecUtil.writeFooter(tempVectorData);
            IOUtils.close(tempVectorData);
            vectorDataInput = this.segmentWriteState.directory.openInput(tempVectorData.getName(), this.segmentWriteState.context);
            this.vectorData.copyBytes(vectorDataInput, vectorDataInput.length() - (long)CodecUtil.footerLength());
            CodecUtil.retrieveChecksum(vectorDataInput);
            long vectorDataLength = this.vectorData.getFilePointer() - vectorDataOffset;
            long vectorIndexOffset = this.vectorIndex.getFilePointer();
            Lucene91HnswVectorsReader.OffHeapVectorValues offHeapVectors = new Lucene91HnswVectorsReader.OffHeapVectorValues(vectors.dimension(), docsWithField.cardinality(), null, vectorDataInput);
            OnHeapHnswGraph graph = offHeapVectors.size() == 0 ? null : this.writeGraph(offHeapVectors, fieldInfo.getVectorSimilarityFunction());
            long vectorIndexLength = this.vectorIndex.getFilePointer() - vectorIndexOffset;
            this.writeMeta(fieldInfo, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, docsWithField, graph);
            success = true;
        }
        catch (Throwable throwable) {
            IOUtils.close(vectorDataInput);
            if (success) {
                this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
            } else {
                IOUtils.closeWhileHandlingException(tempVectorData);
                IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
            }
            throw throwable;
        }
        IOUtils.close(vectorDataInput);
        if (success) {
            this.segmentWriteState.directory.deleteFile(tempVectorData.getName());
        } else {
            IOUtils.closeWhileHandlingException(tempVectorData);
            IOUtils.deleteFilesIgnoringExceptions(this.segmentWriteState.directory, tempVectorData.getName());
        }
    }

    private static DocsWithFieldSet writeVectorData(IndexOutput output, VectorValues vectors) throws IOException {
        DocsWithFieldSet docsWithField = new DocsWithFieldSet();
        int docV = vectors.nextDoc();
        while (docV != Integer.MAX_VALUE) {
            BytesRef binaryValue = vectors.binaryValue();
            assert (binaryValue.length == vectors.dimension() * 4);
            output.writeBytes(binaryValue.bytes, binaryValue.offset, binaryValue.length);
            docsWithField.add(docV);
            docV = vectors.nextDoc();
        }
        return docsWithField;
    }

    private void writeMeta(FieldInfo field, long vectorDataOffset, long vectorDataLength, long vectorIndexOffset, long vectorIndexLength, DocsWithFieldSet docsWithField, OnHeapHnswGraph graph) throws IOException {
        this.meta.writeInt(field.number);
        this.meta.writeInt(field.getVectorSimilarityFunction().ordinal());
        this.meta.writeVLong(vectorDataOffset);
        this.meta.writeVLong(vectorDataLength);
        this.meta.writeVLong(vectorIndexOffset);
        this.meta.writeVLong(vectorIndexLength);
        this.meta.writeInt(field.getVectorDimension());
        int count = docsWithField.cardinality();
        this.meta.writeInt(count);
        if (count == this.maxDoc) {
            this.meta.writeByte((byte)-1);
        } else {
            this.meta.writeByte((byte)0);
            DocIdSetIterator iter = docsWithField.iterator();
            int doc = iter.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                this.meta.writeInt(doc);
                doc = iter.nextDoc();
            }
        }
        this.meta.writeInt(this.maxConn);
        if (graph == null) {
            this.meta.writeInt(0);
        } else {
            this.meta.writeInt(graph.numLevels());
            for (int level = 0; level < graph.numLevels(); ++level) {
                HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
                this.meta.writeInt(nodesOnLevel.size());
                if (level <= 0) continue;
                while (nodesOnLevel.hasNext()) {
                    int node = nodesOnLevel.nextInt();
                    this.meta.writeInt(node);
                }
            }
        }
    }

    private OnHeapHnswGraph writeGraph(RandomAccessVectorValuesProducer vectorValues, VectorSimilarityFunction similarityFunction) throws IOException {
        HnswGraphBuilder hnswGraphBuilder = new HnswGraphBuilder(vectorValues, similarityFunction, this.maxConn, this.beamWidth, HnswGraphBuilder.randSeed);
        hnswGraphBuilder.setInfoStream(this.segmentWriteState.infoStream);
        OnHeapHnswGraph graph = hnswGraphBuilder.build(vectorValues.randomAccess());
        int countOnLevel0 = graph.size();
        for (int level = 0; level < graph.numLevels(); ++level) {
            HnswGraph.NodesIterator nodesOnLevel = graph.getNodesOnLevel(level);
            while (nodesOnLevel.hasNext()) {
                int i;
                int node = nodesOnLevel.nextInt();
                NeighborArray neighbors = graph.getNeighbors(level, node);
                int size = neighbors.size();
                this.vectorIndex.writeInt(size);
                int[] nnodes = neighbors.node();
                Arrays.sort(nnodes, 0, size);
                for (i = 0; i < size; ++i) {
                    int nnode = nnodes[i];
                    assert (nnode < countOnLevel0) : "node too large: " + nnode + ">=" + countOnLevel0;
                    this.vectorIndex.writeInt(nnode);
                }
                for (i = size; i < this.maxConn; ++i) {
                    this.vectorIndex.writeInt(0);
                }
            }
        }
        return graph;
    }

    @Override
    public void finish() throws IOException {
        if (this.finished) {
            throw new IllegalStateException("already finished");
        }
        this.finished = true;
        if (this.meta != null) {
            this.meta.writeInt(-1);
            CodecUtil.writeFooter(this.meta);
        }
        if (this.vectorData != null) {
            CodecUtil.writeFooter(this.vectorData);
            CodecUtil.writeFooter(this.vectorIndex);
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.meta, this.vectorData, this.vectorIndex);
    }
}

