/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene90;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.SplittableRandom;
import org.apache.lucene.index.RandomAccessVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.apache.lucene.util.hnsw.BoundsChecker;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.NeighborQueue;

public final class Lucene90OnHeapHnswGraph
extends HnswGraph {
    private final int maxConn;
    private final List<NeighborArray> graph = new ArrayList<NeighborArray>();
    private int upto;
    private NeighborArray cur;

    Lucene90OnHeapHnswGraph(int maxConn) {
        this.graph.add(new NeighborArray(Math.max(32, maxConn / 4)));
        this.maxConn = maxConn;
    }

    public static NeighborQueue search(float[] query, int topK, int numSeed, RandomAccessVectorValues vectors, VectorSimilarityFunction similarityFunction, HnswGraph graphValues, Bits acceptOrds, int visitedLimit, SplittableRandom random) throws IOException {
        int size = graphValues.size();
        NeighborQueue results = new NeighborQueue(numSeed, similarityFunction.reversed);
        NeighborQueue candidates = new NeighborQueue(numSeed, !similarityFunction.reversed);
        int numVisited = 0;
        SparseFixedBitSet visited = new SparseFixedBitSet(size);
        int boundedNumSeed = Math.min(numSeed, 2 * size);
        for (int i = 0; i < boundedNumSeed; ++i) {
            int entryPoint = random.nextInt(size);
            if (visited.getAndSet(entryPoint)) continue;
            if (numVisited >= visitedLimit) {
                results.markIncomplete();
                break;
            }
            float score = similarityFunction.compare(query, vectors.vectorValue(entryPoint));
            candidates.add(entryPoint, score);
            if (acceptOrds == null || acceptOrds.get(entryPoint)) {
                results.add(entryPoint, score);
            }
            ++numVisited;
        }
        BoundsChecker bound = BoundsChecker.create((boolean)similarityFunction.reversed);
        bound.set(results.topScore());
        block1: while (candidates.size() > 0 && !results.incomplete()) {
            int friendOrd;
            float topCandidateScore = candidates.topScore();
            if (results.size() >= topK && bound.check(topCandidateScore)) break;
            int topCandidateNode = candidates.pop();
            graphValues.seek(0, topCandidateNode);
            while ((friendOrd = graphValues.nextNeighbor()) != Integer.MAX_VALUE) {
                assert (friendOrd < size) : "friendOrd=" + friendOrd + "; size=" + size;
                if (visited.getAndSet(friendOrd)) continue;
                if (numVisited >= visitedLimit) {
                    results.markIncomplete();
                    continue block1;
                }
                float score = similarityFunction.compare(query, vectors.vectorValue(friendOrd));
                if (results.size() < numSeed || !bound.check(score)) {
                    candidates.add(friendOrd, score);
                    if (acceptOrds == null || acceptOrds.get(friendOrd)) {
                        results.insertWithOverflow(friendOrd, score);
                        bound.set(results.topScore());
                    }
                }
                ++numVisited;
            }
        }
        while (results.size() > topK) {
            results.pop();
        }
        results.setVisitedCount(numVisited);
        return results;
    }

    public NeighborArray getNeighbors(int node) {
        return this.graph.get(node);
    }

    public int size() {
        return this.graph.size();
    }

    int addNode() {
        this.graph.add(new NeighborArray(this.maxConn + 1));
        return this.graph.size() - 1;
    }

    public void seek(int level, int targetNode) {
        this.cur = this.getNeighbors(targetNode);
        this.upto = -1;
    }

    public int nextNeighbor() {
        if (++this.upto < this.cur.size()) {
            return this.cur.node()[this.upto];
        }
        return Integer.MAX_VALUE;
    }

    public int numLevels() {
        throw new UnsupportedOperationException();
    }

    public int entryNode() {
        throw new UnsupportedOperationException();
    }

    public HnswGraph.NodesIterator getNodesOnLevel(int level) {
        throw new UnsupportedOperationException();
    }
}

