/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.other.pkg;

import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.status.StatusData;
import org.apache.logging.log4j.status.StatusListener;
import org.apache.logging.log4j.status.StatusLogger;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class LoggerContextAnchorTest {
    private static final String PREFIX = "Log4jLoggerFactory.getContext() found anchor class ";

    @Test
    public void testLoggerFactoryLookupClass() {
        String fqcn = LoggerContextAnchorTest.getAnchorFqcn(() -> LoggerFactory.getLogger(LoggerContextAnchorTest.class));
        Assert.assertEquals((Object)this.getClass().getName(), (Object)fqcn);
    }

    @Test
    public void testLoggerFactoryLookupString() {
        String fqcn = LoggerContextAnchorTest.getAnchorFqcn(() -> LoggerFactory.getLogger((String)"custom.logger"));
        Assert.assertEquals((Object)this.getClass().getName(), (Object)fqcn);
    }

    @Test
    public void testLoggerFactoryGetILoggerFactoryLookup() {
        String fqcn = LoggerContextAnchorTest.getAnchorFqcn(() -> LoggerFactory.getILoggerFactory().getLogger("custom.logger"));
        Assert.assertEquals((Object)this.getClass().getName(), (Object)fqcn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getAnchorFqcn(Runnable runnable) {
        final CopyOnWriteArrayList results = new CopyOnWriteArrayList();
        StatusListener listener = new StatusListener(){

            public void log(StatusData data) {
                String formattedMessage = data.getMessage().getFormattedMessage();
                if (formattedMessage.startsWith(LoggerContextAnchorTest.PREFIX)) {
                    results.add(formattedMessage.substring(LoggerContextAnchorTest.PREFIX.length()));
                }
            }

            public Level getStatusLevel() {
                return Level.TRACE;
            }

            public void close() {
            }
        };
        StatusLogger statusLogger = StatusLogger.getLogger();
        statusLogger.registerListener(listener);
        try {
            runnable.run();
            if (results.isEmpty()) {
                throw new AssertionError((Object)"Failed to locate an anchor lookup status message");
            }
            if (results.size() > 1) {
                throw new AssertionError((Object)("Found multiple anchor lines: " + results));
            }
            String string = (String)results.get(0);
            return string;
        }
        finally {
            statusLogger.removeListener(listener);
        }
    }
}

