/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import java.io.File;
import java.util.List;
import lombok.NonNull;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XStorage;
import org.apache.lens.cli.commands.LensCRUDCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Storage Management", description="These commands provide CRUD for Storages")
public class LensStorageCommands
extends LensCRUDCommand<XStorage>
implements CommandMarker {
    @CliCommand(value={"show storages"}, help="list all storages")
    public String getStorages() {
        return this.showAll();
    }

    @CliCommand(value={"create storage"}, help="Create a new Storage from file <path-to-storage-spec>")
    public String createStorage(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-storage-spec>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.create(path, false);
    }

    @CliCommand(value={"drop storage"}, help="drop storage <storage-name>")
    public String dropStorage(@CliOption(key={"", "name"}, mandatory=true, help="<storage-name>") String name) {
        return this.drop(name, false);
    }

    @CliCommand(value={"update storage"}, help="update storage <storage-name> with storage spec from <path-to-storage-spec>")
    public String updateStorage(@CliOption(key={"", "name"}, mandatory=true, help="<storage-name>") String name, @CliOption(key={"", "path"}, mandatory=true, help="<path-to-storage-spec>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.update(name, path);
    }

    @CliCommand(value={"describe storage"}, help="describe storage <storage-name>")
    public String describeStorage(@CliOption(key={"", "name"}, mandatory=true, help="<storage-name>") String name) {
        return this.describe(name);
    }

    @Override
    public List<String> getAll() {
        return this.getClient().getAllStorages();
    }

    @Override
    protected APIResult doCreate(String path, boolean ignoreIfExists) {
        return this.getClient().createStorage(path);
    }

    @Override
    protected XStorage doRead(String name) {
        return this.getClient().getStorage(name);
    }

    @Override
    public APIResult doUpdate(String name, String path) {
        return this.getClient().updateStorage(name, path);
    }

    @Override
    protected APIResult doDelete(String name, boolean cascade) {
        return this.getClient().dropStorage(name);
    }
}

