/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.api.query.InMemoryQueryResult;
import org.apache.lens.api.query.LensPreparedQuery;
import org.apache.lens.api.query.LensQuery;
import org.apache.lens.api.query.PersistentQueryResult;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryPlan;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.api.query.QueryResult;
import org.apache.lens.api.query.QueryResultSetMetadata;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.api.query.ResultColumn;
import org.apache.lens.cli.commands.BaseLensCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.apache.lens.client.LensClient;
import org.apache.lens.client.exceptions.LensAPIException;
import org.apache.lens.client.exceptions.LensBriefErrorException;
import org.apache.lens.client.model.BriefError;
import org.apache.lens.client.model.IdBriefErrorTemplate;
import org.apache.lens.client.model.IdBriefErrorTemplateKey;
import org.codehaus.jackson.PrettyPrinter;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Query Management", description="This section provides commands for query life cycle - submit, check status,\n  fetch results, kill or list all the queries. Also provides commands for\n  prepare a query, destroy a prepared query and list all prepared queries.\n\n  Please note that, character <<<\">>> is used as delimiter by the Spring Shell\n  framework, which is used to build lens cli. So queries which require <<<\">>>,\n  should be prefixed with another double quote. For example\n  <<<query execute cube select id,name from dim_table where name != \"\"first\"\">>>,\n  will be parsed as <<<cube select id,name from dim_table where name != \"first\">>>")
public class LensQueryCommands
extends BaseLensCommand {
    public static final String DEFAULT_QUERY_HANDLE_DESCRIPTION = "If not provided, takes last query handle interacted with.";
    private static final String ASYNC_DOC = "If <async> is true, The query is launched in async manner and query handle is returned. It's by default false.";
    private static final String QUERY_NAME_DOC = "<query name> can also be provided, though not required.";

    @CliCommand(value={"select"}, help="Execute query <select query-string-without-select>. If <async> is true, The query is launched in async manner and query handle is returned. It's by default false. <query name> can also be provided, though not required.")
    public String executeSelectQuery(@CliOption(key={""}, mandatory=true, help="<query-string-without-select>") String sql, @CliOption(key={"async"}, mandatory=false, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="<async>") boolean async, @CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName) {
        return this.executeQuery("select " + sql, async, queryName);
    }

    @CliCommand(value={"cube select"}, help="Execute cube query <cube select query-string-without-cube-select>. If <async> is true, The query is launched in async manner and query handle is returned. It's by default false. <query name> can also be provided, though not required.")
    public String executeCubeSelectQuery(@CliOption(key={""}, mandatory=true, help="<query-string-without-cube-select>") String sql, @CliOption(key={"async"}, mandatory=false, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="<async>") boolean async, @CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName) {
        return this.executeQuery("cube select " + sql, async, queryName);
    }

    @CliCommand(value={"query execute"}, help="Execute query <query-string>. If <async> is true, The query is launched in async manner and query handle is returned. It's by default false. <query name> can also be provided, though not required.")
    public String executeQuery(@CliOption(key={"", "query"}, mandatory=true, help="<query-string>") String sql, @CliOption(key={"async"}, mandatory=false, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="<async>") boolean async, @CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName) {
        IdBriefErrorTemplate cliOutput;
        try {
            if (async) {
                QueryHandle queryHandle = (QueryHandle)this.getClient().executeQueryAsynch(sql, queryName).getData();
                return queryHandle.getHandleIdString();
            }
            return this.formatResultSet(this.getClient().getResults(sql, queryName));
        }
        catch (LensAPIException e) {
            BriefError briefError = new BriefError(e.getLensAPIErrorCode(), e.getLensAPIErrorMessage());
            cliOutput = new IdBriefErrorTemplate(IdBriefErrorTemplateKey.REQUEST_ID, e.getLensAPIRequestId(), briefError);
        }
        catch (LensBriefErrorException e) {
            cliOutput = e.getIdBriefErrorTemplate();
        }
        return cliOutput.toPrettyString();
    }

    private String formatResultSet(LensClient.LensClientResultSetWithStats rs) {
        StringBuilder b = new StringBuilder();
        if (rs.getResultSet() != null) {
            InMemoryQueryResult temp;
            QueryResultSetMetadata resultSetMetadata = rs.getResultSet().getResultSetMetadata();
            for (ResultColumn column : resultSetMetadata.getColumns()) {
                b.append(column.getName()).append("\t");
            }
            b.append("\n");
            QueryResult r = rs.getResultSet().getResult();
            if (r instanceof InMemoryQueryResult) {
                temp = (InMemoryQueryResult)r;
                b.append(temp.toPrettyString());
            } else {
                temp = (PersistentQueryResult)r;
                b.append("Results of query stored at : ").append(temp.getPersistedURI()).append("  ");
                if (null != temp.getNumRows()) {
                    b.append(temp.getNumRows()).append(" rows ");
                }
            }
        }
        if (rs.getQuery() != null) {
            long submissionTime = rs.getQuery().getSubmissionTime();
            long endTime = rs.getQuery().getFinishTime();
            b.append("processed in (").append(endTime > 0L ? (endTime - submissionTime) / 1000L : 0L).append(") seconds.\n");
        }
        return b.toString();
    }

    @CliCommand(value={"query status"}, help="Fetch status of executed query having query handle <query_handle>. If not provided, takes last query handle interacted with.")
    public String getStatus(@CliOption(key={"", "query_handle"}, mandatory=false, help="<query_handle>") String qh) {
        qh = this.getOrDefaultQueryHandleString(qh);
        QueryHandle handle = QueryHandle.fromString((String)qh);
        QueryStatus status = this.getClient().getQueryStatus(handle);
        if (status == null) {
            return "Unable to find status for " + handle;
        }
        return "Query Handle: " + qh + "\n" + status.toString();
    }

    @CliCommand(value={"query details"}, help="Get query details of query with handle <query_handle>.If not provided, takes last query handle interacted with.")
    public String getDetails(@CliOption(key={"", "query_handle"}, mandatory=false, help="<query_handle>") String qh) {
        qh = this.getOrDefaultQueryHandleString(qh);
        LensQuery query = this.getClient().getQueryDetails(qh);
        if (query == null) {
            return "Unable to find query for " + qh;
        }
        try {
            return this.formatJson(this.mapper.writer((PrettyPrinter)this.pp).writeValueAsString((Object)query));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @CliCommand(value={"query explain"}, help="Explain execution plan of query <query-string>. Can optionally save the plan to a file by providing <save_location>")
    public String explainQuery(@CliOption(key={"", "query"}, mandatory=true, help="<query-string>") String sql, @CliOption(key={"save_location"}, mandatory=false, help="<save_location>") File path) throws IOException, LensAPIException {
        IdBriefErrorTemplate cliOutput;
        try {
            QueryPlan plan = (QueryPlan)this.getClient().getQueryPlan(sql).getData();
            if (path != null && StringUtils.isNotBlank((String)path.getPath())) {
                String validPath = this.getValidPath(path, false, false);
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(validPath), Charset.defaultCharset());){
                    osw.write(plan.getPlanString());
                }
                return "Saved to " + validPath;
            }
            return plan.getPlanString();
        }
        catch (LensAPIException e) {
            BriefError briefError = new BriefError(e.getLensAPIErrorCode(), e.getLensAPIErrorMessage());
            cliOutput = new IdBriefErrorTemplate(IdBriefErrorTemplateKey.REQUEST_ID, e.getLensAPIRequestId(), briefError);
        }
        catch (LensBriefErrorException e) {
            cliOutput = e.getIdBriefErrorTemplate();
        }
        return cliOutput.toPrettyString();
    }

    @CliCommand(value={"query list"}, help="Get all queries. Various filter options can be provided(optionally),  as can be seen from the command syntax")
    public String getAllQueries(@CliOption(key={"state"}, mandatory=false, help="<query-status>") String state, @CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName, @CliOption(key={"user"}, mandatory=false, help="<user-who-submitted-query>") String user, @CliOption(key={"driver"}, mandatory=false, help="<driver-where-query-ran>") String driver, @CliOption(key={"fromDate"}, mandatory=false, unspecifiedDefaultValue="-1", help="<submission-time-is-after>") long fromDate, @CliOption(key={"toDate"}, mandatory=false, unspecifiedDefaultValue="9223372036854775807", help="<submission-time-is-before>") long toDate) {
        List handles = this.getClient().getQueries(state, queryName, user, driver, fromDate, toDate);
        if (handles != null && !handles.isEmpty()) {
            return Joiner.on((String)"\n").skipNulls().join((Iterable)handles).concat("\n").concat("Total number of queries: " + handles.size());
        }
        return "No queries";
    }

    @CliCommand(value={"query kill"}, help="Kill query with handle <query_handle>.If not provided, takes last query handle interacted with.")
    public String killQuery(@CliOption(key={"", "query_handle"}, mandatory=false, help="<query_handle>") String qh) {
        qh = this.getOrDefaultQueryHandleString(qh);
        boolean status = this.getClient().killQuery(new QueryHandle(UUID.fromString(qh)));
        if (status) {
            return "Successfully killed " + qh;
        }
        return "Failed in killing " + qh;
    }

    @CliCommand(value={"query results"}, help="get results of query with query handle <query_handle>. If not provided, takes last query handle interacted with.If async is false then wait till the query execution is completed, it's by default true. Can optionally save the results to a file by providing <save_location>.")
    public String getQueryResults(@CliOption(key={"", "query_handle"}, mandatory=false, help="<query_handle>") String qh, @CliOption(key={"save_location"}, mandatory=false, help="<save_location>") File path, @CliOption(key={"async"}, mandatory=false, unspecifiedDefaultValue="true", help="<async>") boolean async) {
        qh = this.getOrDefaultQueryHandleString(qh);
        QueryHandle queryHandle = new QueryHandle(UUID.fromString(qh));
        String location = path != null ? path.getPath() : null;
        try {
            if (StringUtils.isNotBlank((String)location)) {
                location = this.getValidPath(path, true, true);
                Response response = this.getClient().getHttpResults(queryHandle);
                if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                    String disposition = (String)((List)response.getHeaders().get((Object)"content-disposition")).get(0);
                    String fileName = disposition.split("=")[1].trim();
                    location = this.getValidPath(new File(location + File.separator + fileName), false, false);
                    try (InputStream stream = (InputStream)response.readEntity(InputStream.class);
                         FileOutputStream outStream = new FileOutputStream(new File(location));){
                        IOUtils.copy((InputStream)stream, (OutputStream)outStream);
                    }
                    return "Saved to " + location;
                }
                LensClient.LensClientResultSetWithStats results = async ? this.getClient().getAsyncResults(queryHandle) : this.getClient().getSyncResults(queryHandle);
                if (results.getResultSet() == null) {
                    return "Resultset not yet available";
                }
                if (results.getResultSet().getResult() instanceof InMemoryQueryResult) {
                    location = this.getValidPath(new File(location + File.separator + qh + ".csv"), false, false);
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(location), Charset.defaultCharset());){
                        osw.write(this.formatResultSet(results));
                    }
                    return "Saved to " + location;
                }
                return "Can't download the result because it's available in driver's persistence.\n" + this.formatResultSet(results);
            }
            if (async) {
                return this.formatResultSet(this.getClient().getAsyncResults(queryHandle));
            }
            return this.formatResultSet(this.getClient().getSyncResults(queryHandle));
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    @CliCommand(value={"prepQuery list"}, help="Get all prepared queries. Various filters can be provided(optionally) as can be seen from command syntax")
    public String getAllPreparedQueries(@CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName, @CliOption(key={"user"}, mandatory=false, help="<user-who-submitted-query>") String userName, @CliOption(key={"fromDate"}, mandatory=false, unspecifiedDefaultValue="-1", help="<submission-time-is-after>") long fromDate, @CliOption(key={"toDate"}, mandatory=false, unspecifiedDefaultValue="9223372036854775807", help="<submission-time-is-before>") long toDate) {
        List handles = this.getClient().getPreparedQueries(userName, queryName, fromDate, toDate);
        if (handles != null && !handles.isEmpty()) {
            return Joiner.on((String)"\n").skipNulls().join((Iterable)handles);
        }
        return "No prepared queries";
    }

    @CliCommand(value={"prepQuery details"}, help="Get prepared query with handle <prepare_handle>")
    public String getPreparedStatus(@CliOption(key={"", "prepare_handle"}, mandatory=true, help="<prepare_handle>") String ph) {
        LensPreparedQuery prepared = this.getClient().getPreparedQuery(QueryPrepareHandle.fromString((String)ph));
        if (prepared != null) {
            StringBuilder sb = new StringBuilder().append("User query:").append(prepared.getUserQuery()).append("\n").append("Prepare handle:").append(prepared.getPrepareHandle()).append("\n").append("User:").append(prepared.getPreparedUser()).append("\n").append("Prepared at:").append(prepared.getPreparedTime()).append("\n").append("Selected driver :").append(prepared.getSelectedDriverName()).append("\n").append("Driver query:").append(prepared.getDriverQuery()).append("\n");
            if (prepared.getConf() != null) {
                sb.append("Conf:").append(prepared.getConf().getProperties()).append("\n");
            }
            return sb.toString();
        }
        return "No such handle";
    }

    @CliCommand(value={"prepQuery destroy"}, help="Destroy prepared query with handle <prepare_handle>")
    public String destroyPreparedQuery(@CliOption(key={"", "prepare_handle"}, mandatory=true, help="<prepare_handle>") String ph) {
        boolean status = this.getClient().destroyPrepared(new QueryPrepareHandle(UUID.fromString(ph)));
        if (status) {
            return "Successfully destroyed " + ph;
        }
        return "Failed in destroying " + ph;
    }

    @CliCommand(value={"prepQuery execute"}, help="Execute prepared query with handle <prepare_handle>. If <async> is supplied and is true, query is run in async manner and query handle is returned immediately. Optionally, <query-name> can be provided, though not required.")
    public String executePreparedQuery(@CliOption(key={"", "prepare_handle"}, mandatory=true, help="Prepare handle to execute") String phandle, @CliOption(key={"async"}, mandatory=false, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="<async>") boolean async, @CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName) {
        if (async) {
            QueryHandle handle = this.getClient().executePrepared(QueryPrepareHandle.fromString((String)phandle), queryName);
            return handle.getHandleId().toString();
        }
        try {
            LensClient.LensClientResultSetWithStats result = this.getClient().getResultsFromPrepared(QueryPrepareHandle.fromString((String)phandle), queryName);
            return this.formatResultSet(result);
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    @CliCommand(value={"prepQuery prepare"}, help="Prepapre query <query-string> and return prepare handle. Can optionaly provide <query-name>")
    public String prepare(@CliOption(key={"", "query"}, mandatory=true, help="<query-string>") String sql, @CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName) throws UnsupportedEncodingException, LensAPIException {
        return ((QueryPrepareHandle)this.getClient().prepare(sql, queryName).getData()).toString();
    }

    @CliCommand(value={"prepQuery explain"}, help="Explain and prepare query <query-string>. Can optionally provide <query-name>")
    public String explainAndPrepare(@CliOption(key={"", "query"}, mandatory=true, help="<query-string>") String sql, @CliOption(key={"name"}, mandatory=false, help="<query-name>") String queryName) throws UnsupportedEncodingException, LensAPIException {
        IdBriefErrorTemplate cliOutput;
        try {
            QueryPlan plan = (QueryPlan)this.getClient().explainAndPrepare(sql, queryName).getData();
            return plan.getPlanString() + "\n" + "Prepare handle:" + plan.getPrepareHandle();
        }
        catch (LensAPIException e) {
            BriefError briefError = new BriefError(e.getLensAPIErrorCode(), e.getLensAPIErrorMessage());
            cliOutput = new IdBriefErrorTemplate(IdBriefErrorTemplateKey.REQUEST_ID, e.getLensAPIRequestId(), briefError);
        }
        catch (LensBriefErrorException e) {
            cliOutput = e.getIdBriefErrorTemplate();
        }
        return cliOutput.toPrettyString();
    }
}

