/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import java.util.List;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XNativeTable;
import org.apache.lens.cli.commands.LensCRUDCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Native Table Management", description="Read operations on native tables")
public class LensNativeTableCommands
extends LensCRUDCommand<XNativeTable> {
    @CliCommand(value={"show nativetables"}, help="show list of native tables belonging to current database")
    public String showNativeTables() {
        return this.showAll();
    }

    @CliCommand(value={"describe nativetable"}, help="describe nativetable named <native-table-name>")
    public String describeNativeTable(@CliOption(key={"", "name"}, mandatory=true, help="<native-table-name>") String name) {
        return this.describe(name);
    }

    @Override
    public List<String> getAll() {
        return this.getClient().getAllNativeTables();
    }

    @Override
    protected APIResult doCreate(String path, boolean ignoreIfExists) {
        return null;
    }

    @Override
    protected XNativeTable doRead(String name) {
        return this.getClient().getNativeTable(name);
    }

    @Override
    public APIResult doUpdate(String name, String path) {
        return null;
    }

    @Override
    protected APIResult doDelete(String name, boolean cascade) {
        return null;
    }
}

