/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import java.io.File;
import java.util.List;
import lombok.NonNull;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XFactTable;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.cli.commands.LogicalTableCrudCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Facts Management", description="These command provide CRUD for facts, associated storages, and fact partitions")
public class LensFactCommands
extends LogicalTableCrudCommand<XFactTable> {
    @CliCommand(value={"show facts"}, help="display list of fact tables in current database. If optional <cube_name> is supplied, only facts belonging to cube <cube_name> will be displayed")
    public String showFacts(@CliOption(key={"", "cube_name"}, mandatory=false, help="<cube_name>") String cubeName) {
        return this.showAll(cubeName);
    }

    @CliCommand(value={"create fact"}, help="create a fact table with spec from <path-to-fact-spec-file>")
    public String createFact(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-fact-spec-file>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.create(path, false);
    }

    @CliCommand(value={"describe fact"}, help="describe fact <fact_name>")
    public String describeFactTable(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String name) {
        return this.describe(name);
    }

    @CliCommand(value={"update fact"}, help="update fact <fact_name> taking spec from <path-to-fact-spec>")
    public String updateFactTable(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String name, @CliOption(key={"", "path"}, mandatory=true, help="<path-to-fact-spec>") @NonNull File specPath) {
        if (specPath == null) {
            throw new NullPointerException("specPath");
        }
        return this.update(name, specPath);
    }

    @CliCommand(value={"drop fact"}, help="drops fact <fact_name>. If <cascade> is true, all the storage tables associated with the fact <fact_name> are also dropped. By default <cascade> is false")
    public String dropFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String fact, @CliOption(key={"cascade"}, mandatory=false, unspecifiedDefaultValue="false", help="<cascade>") boolean cascade) {
        return this.drop(fact, cascade);
    }

    @CliCommand(value={"fact list storage"}, help="display list of storages associated to fact <fact_name>")
    public String getFactStorages(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName) {
        return this.showAllStorages(tableName);
    }

    @CliCommand(value={"fact add storage"}, help="adds a new storage to fact <fact_name>, taking storage spec from <path-to-storage-spec>")
    public String addNewFactStorage(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "path"}, mandatory=true, help="<path-to-storage-spec>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.addStorage(tableName, path);
    }

    @CliCommand(value={"fact get storage"}, help="describe storage <storage_name> of fact <fact_name>")
    public String getStorageFromFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<path-to-storage-spec>") String storage) {
        return this.getStorage(tableName, storage);
    }

    @CliCommand(value={"fact drop storage"}, help="drop storage <storage_name> from fact <fact_name>")
    public String dropStorageFromFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName) {
        return this.dropStorage(tableName, storageName);
    }

    @CliCommand(value={"fact drop all storages"}, help="drop all storages associated to fact <fact_name>")
    public String dropAllFactStorages(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String name) {
        return this.dropAllStorages(name);
    }

    @CliCommand(value={"fact list partitions"}, help="get all partitions associated with fact <fact_name>, storage <storage_name> filtered by <partition-filter>")
    public String getAllPartitionsOfFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "filter"}, mandatory=false, help="<partition-filter>") String filter) {
        return this.getAllPartitions(tableName, storageName, filter);
    }

    @CliCommand(value={"fact drop partitions"}, help="drop all partitions associated with fact <fact_name>, storage <storage_name> filtered by <partition-filter>")
    public String dropAllPartitionsOfFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "filter"}, mandatory=false, help="<partition-filter>") String filter) {
        return this.dropPartitions(tableName, storageName, filter);
    }

    @CliCommand(value={"fact add single-partition"}, help="add single partition to fact <fact_name>'s storage <storage_name>, reading spec from <partition-spec-path>")
    public String addPartitionToFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-spec-path>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.addPartition(tableName, storageName, path);
    }

    @CliCommand(value={"fact update single-partition"}, help="update single partition to fact <fact_name>'s storage <storage_name>, reading spec from <partition-spec-path> The partition has to exist to be eligible for updation.")
    public String updatePartitionOfFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-spec-path>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.updatePartition(tableName, storageName, path);
    }

    @CliCommand(value={"fact add partitions"}, help="add multiple partition to fact <fact_name>'s storage <storage_name>, reading partition list spec from <partition-list-spec-path>")
    public String addPartitionsToFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-list-spec-path>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.addPartitions(tableName, storageName, path.getPath());
    }

    @CliCommand(value={"fact update partitions"}, help="update multiple partition of fact <fact_name>'s storage <storage_name>, reading partition list spec from <partition-list-spec-path> The partitions have to exist to be eligible for updation.")
    public String updatePartitionsOfFact(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String tableName, @CliOption(key={"", "storage_name"}, mandatory=true, help="<storage_name>") String storageName, @CliOption(key={"", "path"}, mandatory=true, help="<partition-list-spec-path>") String path) {
        return this.updatePartitions(tableName, storageName, path);
    }

    @CliCommand(value={"fact timelines"}, help="get timelines for fact. Can optionally specify storage, update period and time dimension to filter by. Instead of time dimension, partition column can be directly passed as <time_dimension>")
    public List<String> getTimelines(@CliOption(key={"", "fact_name"}, mandatory=true, help="<fact_name>") String factName, @CliOption(key={"storage_name"}, mandatory=false, help="<storage_name>") String storageName, @CliOption(key={"update_period"}, mandatory=false, help="<update_period>") String updatePeriod, @CliOption(key={"time_dimension"}, mandatory=false, help="<time_dimension>") String timeDimension) {
        return this.getClient().getPartitionTimelines(factName, storageName, updatePeriod, timeDimension);
    }

    @Override
    protected XStorageTableElement readStorage(String tableName, String storage) {
        return this.getClient().getStorageFromFact(tableName, storage);
    }

    @Override
    public APIResult doDropStorage(String tableName, String storageName) {
        return this.getClient().dropStorageFromFact(tableName, storageName);
    }

    @Override
    public List<String> getAllStorages(String name) {
        return this.getClient().getFactStorages(name);
    }

    @Override
    public APIResult doAddStorage(String name, String path) {
        return this.getClient().addStorageToFact(name, path);
    }

    @Override
    public APIResult doDropAllStorages(String name) {
        return this.getClient().dropAllStoragesOfFact(name);
    }

    @Override
    protected List<XPartition> readAllPartitions(String tableName, String storageName, String filter) {
        return this.getClient().getAllPartitionsOfFact(tableName, storageName, filter);
    }

    @Override
    protected APIResult doAddPartition(String tableName, String storageName, String path) {
        return this.getClient().addPartitionToFact(tableName, storageName, path);
    }

    @Override
    protected APIResult doAddPartitions(String tableName, String storageName, String path) {
        return this.getClient().addPartitionsToFact(tableName, storageName, path);
    }

    @Override
    protected APIResult doDropPartitions(String tableName, String storageName, String filter) {
        return this.getClient().dropAllPartitionsOfFact(tableName, storageName, filter);
    }

    @Override
    protected APIResult doUpdatePartition(String tableName, String storageName, String validPath) {
        return this.getClient().updatePartitionOfFact(tableName, storageName, validPath);
    }

    @Override
    protected APIResult doUpdatePartitions(String tableName, String storageName, String validPath) {
        return this.getClient().updatePartitionsOfFact(tableName, storageName, validPath);
    }

    @Override
    public List<String> getAll() {
        return this.getClient().getAllFactTables();
    }

    @Override
    public List<String> getAll(String cubeName) {
        return this.getClient().getAllFactTables(cubeName);
    }

    @Override
    protected APIResult doCreate(String path, boolean ignoreIfExists) {
        return this.getClient().createFactTable(path);
    }

    @Override
    protected XFactTable doRead(String name) {
        return this.getClient().getFactTable(name);
    }

    @Override
    public APIResult doUpdate(String name, String path) {
        return this.getClient().updateFactTable(name, path);
    }

    @Override
    protected APIResult doDelete(String name, boolean cascade) {
        return this.getClient().dropFactTable(name, cascade);
    }
}

