/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import java.util.List;
import org.apache.lens.api.APIResult;
import org.apache.lens.cli.commands.LensCRUDCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for Database Management", description="These commands provide CRUD for databases")
public class LensDatabaseCommands
extends LensCRUDCommand {
    @CliCommand(value={"show databases"}, help="displays list of all databases")
    public String showAllDatabases() {
        return this.showAll();
    }

    @CliCommand(value={"use"}, help="change to new database")
    public String switchDatabase(@CliOption(key={"", "db"}, mandatory=true, help="<database-name>") String database) {
        boolean status = this.getClient().setDatabase(database);
        if (status) {
            return "Successfully switched to " + database;
        }
        return "Failed to switch to " + database;
    }

    @CliCommand(value={"create database"}, help="create a database with specified name. if <ignore-if-exists> is true, create will not be tried if already exists. Default is false")
    public String createDatabase(@CliOption(key={"", "db"}, mandatory=true, help="<database-name>") String database, @CliOption(key={"ignoreIfExists"}, mandatory=false, unspecifiedDefaultValue="false", help="<ignore-if-exists>") boolean ignoreIfExists) {
        return this.doCreate(database, ignoreIfExists).toString().toLowerCase();
    }

    @CliCommand(value={"drop database"}, help="drop a database with specified name")
    public String dropDatabase(@CliOption(key={"", "db"}, mandatory=true, help="<database-name>") String database, @CliOption(key={"cascade"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false") boolean cascade) {
        return this.drop(database, cascade);
    }

    @Override
    public List<String> getAll() {
        return this.getClient().getAllDatabases();
    }

    @Override
    protected APIResult doCreate(String database, boolean ignoreIfExists) {
        return this.getClient().createDatabase(database, ignoreIfExists);
    }

    protected Object doRead(String name) {
        return null;
    }

    @Override
    public APIResult doUpdate(String name, String path) {
        return null;
    }

    @Override
    protected APIResult doDelete(String name, boolean cascade) {
        return this.getClient().dropDatabase(name, cascade);
    }
}

