/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.cli.commands;

import java.io.File;
import java.util.Date;
import java.util.List;
import lombok.NonNull;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.metastore.XCube;
import org.apache.lens.cli.commands.ConceptualTableCrudCommand;
import org.apache.lens.cli.commands.annotations.UserDocumentation;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
@UserDocumentation(title="Commands for OLAP Data Cube Management", description="These commands provide CRUD for cubes")
public class LensCubeCommands
extends ConceptualTableCrudCommand<XCube> {
    @CliCommand(value={"show cubes"}, help="show list of cubes in current database")
    public String showCubes() {
        return this.showAll();
    }

    @CliCommand(value={"create cube"}, help="Create a new Cube, taking spec from <path-to-cube-spec-file>")
    public String createCube(@CliOption(key={"", "path"}, mandatory=true, help="<path-to-cube-spec-file>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.create(path, false);
    }

    @CliCommand(value={"describe cube"}, help="describe cube with name <cube_name>")
    public String describeCube(@CliOption(key={"", "name"}, mandatory=true, help="<cube_name>") String name) {
        return this.describe(name);
    }

    @CliCommand(value={"update cube"}, help="update cube <cube_name> with spec from <path-to-cube-spec-file>")
    public String updateCube(@CliOption(key={"", "name"}, mandatory=true, help="<cube_name>") String name, @CliOption(key={"", "path"}, mandatory=true, help="<path-to-cube-spec-file>") @NonNull File path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        return this.update(name, path);
    }

    @CliCommand(value={"drop cube"}, help="drop cube <cube_name>")
    public String dropCube(@CliOption(key={"", "name"}, mandatory=true, help="<cube_name>") String name) {
        return this.drop(name, false);
    }

    @CliCommand(value={"cube latestdate"}, help="get latest date of data available in cube <cube_name> for time dimension <time_dimension_name>.  Instead of time dimension, partition column can be directly passed as <time_dimension>")
    public String getLatest(@CliOption(key={"", "name"}, mandatory=true, help="<cube_name>") String cube, @CliOption(key={"", "time_dimension"}, mandatory=true, help="<time_dimension>") String timeDim) {
        Date dt = this.getClient().getLatestDateOfCube(cube, timeDim);
        return dt == null ? "No Data Available" : LensCubeCommands.formatDate(dt);
    }

    @CliCommand(value={"cube show fields"}, help="Show queryable fields of the given cube <cube_name>. Optionally specify <flattened> to include chained fields")
    public String showQueryableFields(@CliOption(key={"", "name"}, mandatory=true, help="<cube_name>") String table, @CliOption(key={"flattened"}, mandatory=false, unspecifiedDefaultValue="false", specifiedDefaultValue="true", help="<flattened>") boolean flattened) {
        return this.getAllFields(table, flattened);
    }

    @CliCommand(value={"cube show joinchains"}, help="Show joinchains of the given cube <cube_name>. ")
    public String showJoinChains(@CliOption(key={"", "name"}, mandatory=true, help="<cube_name>") String table) {
        return this.getAllJoinChains(table);
    }

    @Override
    public List<String> getAll() {
        return this.getClient().getAllCubes();
    }

    @Override
    protected APIResult doCreate(String path, boolean ignoreIfExists) {
        return this.getClient().createCube(path);
    }

    @Override
    protected APIResult doDelete(String name, boolean cascade) {
        return this.getClient().dropCube(name);
    }

    @Override
    public APIResult doUpdate(String name, String path) {
        return this.getClient().updateCube(name, path);
    }

    @Override
    protected XCube doRead(String name) {
        return this.getClient().getCube(name);
    }
}

