/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test.junit;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.org.apache.http.StatusLine;
import org.apache.kudu.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.kudu.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.kudu.shaded.org.apache.http.entity.ContentType;
import org.apache.kudu.shaded.org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.kudu.shaded.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kudu.shaded.org.apache.http.impl.client.HttpClients;
import org.apache.kudu.shaded.org.apache.http.util.EntityUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResultReporter {
    private static final Logger LOG = LoggerFactory.getLogger(ResultReporter.class);
    private static final String KUDU_REPORT_TEST_RESULTS_VAR = "KUDU_REPORT_TEST_RESULTS";
    private static final String TEST_RESULT_SERVER_VAR = "TEST_RESULT_SERVER";
    private static final String BUILD_TAG_VAR = "BUILD_TAG";
    private static final String GIT_REVISION_VAR = "GIT_REVISION";
    private static final String BUILD_CONFIG_VAR = "BUILD_CONFIG";
    private final Options options;

    public ResultReporter() {
        this(new Options().reportResults(ResultReporter.isReportingConfigured()).httpEndpoint(ResultReporter.getEnvStringWithDefault(TEST_RESULT_SERVER_VAR, "localhost:8080")).buildTag(System.getenv(BUILD_TAG_VAR)).revision(System.getenv(GIT_REVISION_VAR)).buildConfig(System.getenv(BUILD_CONFIG_VAR)).hostname(ResultReporter.getLocalHostname()));
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    ResultReporter(Options options) {
        this.options = options;
    }

    private static boolean isVarSetAndNonEmpty(String name) {
        String var = System.getenv(name);
        return var != null && !var.equals("");
    }

    private static boolean areRequiredReportingVarsSetAndNonEmpty() {
        return ResultReporter.isVarSetAndNonEmpty(BUILD_TAG_VAR) && ResultReporter.isVarSetAndNonEmpty(GIT_REVISION_VAR) && ResultReporter.isVarSetAndNonEmpty(BUILD_CONFIG_VAR);
    }

    private static String reportingVarDump() {
        ArrayList<String> vars = new ArrayList<String>();
        for (String var : ImmutableList.of(TEST_RESULT_SERVER_VAR, BUILD_TAG_VAR, GIT_REVISION_VAR, BUILD_CONFIG_VAR)) {
            vars.add(var + ": \"" + System.getenv(var) + "\"");
        }
        return Joiner.on(", ").join(vars);
    }

    private static boolean isReportingConfigured() {
        if (ResultReporter.getEnvIntegerWithDefault(KUDU_REPORT_TEST_RESULTS_VAR, 0) == 0) {
            return false;
        }
        if (!ResultReporter.areRequiredReportingVarsSetAndNonEmpty()) {
            throw new IllegalStateException("Not all required variables are set: " + ResultReporter.reportingVarDump());
        }
        return true;
    }

    private static String getEnvStringWithDefault(String name, String defaultValue) {
        String value = System.getenv(name);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    private static int getEnvIntegerWithDefault(String name, int defaultValue) {
        return Integer.parseInt(ResultReporter.getEnvStringWithDefault(name, String.valueOf(defaultValue)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @InterfaceAudience.LimitedPrivate(value={"Test"})
    static String getLocalHostname() {
        ProcessBuilder pb = new ProcessBuilder("hostname");
        try {
            Process p = pb.start();
            Throwable throwable = null;
            try (InputStreamReader isr = new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8);){
                String string;
                BufferedReader br = new BufferedReader(isr);
                Throwable throwable2 = null;
                try {
                    int rv = p.waitFor();
                    if (rv != 0) {
                        throw new IllegalStateException(String.format("Process 'hostname' exited with exit status %d", rv));
                    }
                    string = br.readLine();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            ResultReporter.$closeResource(throwable2, br);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                ResultReporter.$closeResource(throwable2, br);
                return string;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void reportResult(String testName, Result result, File logFile) throws IOException {
        if (!this.options.reportResults) {
            return;
        }
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost post = new HttpPost("http://" + this.options.httpEndpoint + "/add_result");
            MultipartEntityBuilder meb = MultipartEntityBuilder.create();
            meb.addTextBody("build_id", this.options.buildTag);
            meb.addTextBody("hostname", this.options.hostname);
            meb.addTextBody("revision", this.options.revision);
            meb.addTextBody("build_config", this.options.buildConfig);
            meb.addTextBody("test_name", testName);
            meb.addTextBody("status", Integer.toString(result == Result.SUCCESS ? 0 : 1));
            if (logFile != null) {
                meb.addBinaryBody("log", logFile, ContentType.APPLICATION_OCTET_STREAM, testName + ".txt.gz");
            }
            post.setEntity(meb.build());
            try (CloseableHttpResponse resp = client.execute(post);){
                StatusLine sl = resp.getStatusLine();
                if (sl.getStatusCode() != 200) {
                    throw new IOException("Bad response from server: " + sl.getStatusCode() + ": " + EntityUtils.toString(resp.getEntity(), StandardCharsets.UTF_8));
                }
            }
        }
    }

    public void tryReportResult(String testName, Result result, File logFile) {
        try {
            this.reportResult(testName, result, logFile);
        }
        catch (IOException ex) {
            LOG.warn("Failed to record test result for {} as {}", new Object[]{testName, result, ex});
        }
    }

    public boolean isReportingEnabled() {
        return this.options.reportResults;
    }

    public static class Options {
        private boolean reportResults = true;
        private String httpEndpoint;
        private String buildTag;
        private String revision;
        private String hostname;
        private String buildConfig;

        public Options reportResults(boolean reportResults) {
            this.reportResults = reportResults;
            return this;
        }

        public Options httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        public Options buildTag(String buildTag) {
            this.buildTag = buildTag;
            return this;
        }

        public Options revision(String revision) {
            this.revision = revision;
            return this;
        }

        public Options hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Options buildConfig(String buildConfig) {
            this.buildConfig = buildConfig;
            return this;
        }
    }

    public static enum Result {
        SUCCESS,
        FAILURE;

    }
}

