/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.AsyncKuduSession;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Insert;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.client.Upsert;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.common.collect.Iterators;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.kudu.util.CharUtil;
import org.apache.kudu.util.DateUtil;
import org.apache.kudu.util.DecimalUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ClientTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ClientTestUtil.class);
    public static final Callback<Object, Object> defaultErrorCB = new Callback<Object, Object>(){

        public Object call(Object arg) throws Exception {
            if (arg == null) {
                return null;
            }
            if (arg instanceof Exception) {
                LOG.warn("Got exception", (Throwable)((Exception)arg));
            } else {
                LOG.warn("Got an error response back {}", arg);
            }
            return new Exception("cannot recover from error: " + arg);
        }
    };

    public static int countRowsInScan(AsyncKuduScanner scanner, long timeoutMs) throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        Callback<Object, RowResultIterator> cb = new Callback<Object, RowResultIterator>(){

            public Object call(RowResultIterator arg) throws Exception {
                if (arg == null) {
                    return null;
                }
                counter.addAndGet(arg.getNumRows());
                return null;
            }
        };
        while (scanner.hasMoreRows()) {
            Deferred<RowResultIterator> data = scanner.nextRows();
            data.addCallbacks((Callback)cb, defaultErrorCB);
            data.join(timeoutMs);
        }
        return counter.get();
    }

    public static int countRowsInScan(AsyncKuduScanner scanner) throws Exception {
        return ClientTestUtil.countRowsInScan(scanner, 60000L);
    }

    public static int countRowsInScan(KuduScanner scanner) throws KuduException {
        int counter = 0;
        while (scanner.hasMoreRows()) {
            counter += scanner.nextRows().getNumRows();
        }
        return counter;
    }

    public static long countRowsInTable(KuduTable table, KuduPredicate ... predicates) throws KuduException {
        KuduScanner.KuduScannerBuilder scanBuilder = table.getAsyncClient().syncClient().newScannerBuilder(table);
        for (KuduPredicate predicate : predicates) {
            scanBuilder.addPredicate(predicate);
        }
        scanBuilder.setProjectedColumnIndexes(ImmutableList.of());
        return ClientTestUtil.countRowsInScan(scanBuilder.build());
    }

    public static int countScanTokenRows(List<KuduScanToken> tokens, final String masterAddresses, final long operationTimeoutMs) throws IOException, InterruptedException {
        final AtomicInteger count = new AtomicInteger(0);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (KuduScanToken token : tokens) {
            final byte[] serializedToken = token.serialize();
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (KuduClient contextClient = new KuduClient.KuduClientBuilder(masterAddresses).defaultAdminOperationTimeoutMs(operationTimeoutMs).build();
                         KuduScanner scanner = KuduScanToken.deserializeIntoScanner(serializedToken, contextClient);){
                        int localCount = 0;
                        while (scanner.hasMoreRows()) {
                            localCount += Iterators.size(scanner.nextRows());
                        }
                        count.addAndGet(localCount);
                    }
                    catch (Exception e) {
                        LOG.error("exception in parallel token scanner", (Throwable)e);
                    }
                }
            });
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.join();
        }
        return count.get();
    }

    public static List<String> scanTableToStrings(KuduTable table, KuduPredicate ... predicates) throws Exception {
        ArrayList<String> rowStrings = Lists.newArrayList();
        KuduScanner.KuduScannerBuilder scanBuilder = table.getAsyncClient().syncClient().newScannerBuilder(table);
        for (KuduPredicate predicate : predicates) {
            scanBuilder.addPredicate(predicate);
        }
        KuduScanner scanner = scanBuilder.build();
        for (RowResult r : scanner) {
            rowStrings.add(r.rowToString());
        }
        Collections.sort(rowStrings);
        return rowStrings;
    }

    public static Schema getSchemaWithAllTypes() {
        ImmutableList<ColumnSchema> columns = ImmutableList.of(new ColumnSchema.ColumnSchemaBuilder("int8", Type.INT8).key(true).build(), new ColumnSchema.ColumnSchemaBuilder("int16", Type.INT16).build(), new ColumnSchema.ColumnSchemaBuilder("int32", Type.INT32).build(), new ColumnSchema.ColumnSchemaBuilder("int64", Type.INT64).build(), new ColumnSchema.ColumnSchemaBuilder("bool", Type.BOOL).build(), new ColumnSchema.ColumnSchemaBuilder("float", Type.FLOAT).build(), new ColumnSchema.ColumnSchemaBuilder("double", Type.DOUBLE).build(), new ColumnSchema.ColumnSchemaBuilder("string", Type.STRING).build(), new ColumnSchema.ColumnSchemaBuilder("binary-array", Type.BINARY).build(), new ColumnSchema.ColumnSchemaBuilder("binary-bytebuffer", Type.BINARY).build(), new ColumnSchema.ColumnSchemaBuilder("null", Type.STRING).nullable(true).build(), new ColumnSchema.ColumnSchemaBuilder("timestamp", Type.UNIXTIME_MICROS).build(), new ColumnSchema[]{new ColumnSchema.ColumnSchemaBuilder("decimal", Type.DECIMAL).typeAttributes(DecimalUtil.typeAttributes(5, 3)).build(), new ColumnSchema.ColumnSchemaBuilder("varchar", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes(10)).build(), new ColumnSchema.ColumnSchemaBuilder("date", Type.DATE).build()});
        return new Schema(columns);
    }

    public static PartialRow getPartialRowWithAllTypes(PartialRow row, byte int8Value) {
        if (row == null) {
            Schema schema = ClientTestUtil.getSchemaWithAllTypes();
            Assert.assertEquals((long)15L, (long)schema.getColumnCount());
            row = schema.newPartialRow();
        }
        row.addByte("int8", int8Value);
        row.addShort("int16", (short)43);
        row.addInt("int32", 44);
        row.addLong("int64", 45L);
        row.addTimestamp("timestamp", new Timestamp(1234567890L));
        row.addDate("date", DateUtil.epochDaysToSqlDate(0));
        row.addBoolean("bool", true);
        row.addFloat("float", 52.35f);
        row.addDouble("double", 53.35);
        row.addString("string", "fun with \u00fctf\u0000");
        row.addVarchar("varchar", "\u00e1rv\u00edzt\u0171r\u0151 t\u00fck\u00f6rf\u00far\u00f3g\u00e9p");
        row.addBinary("binary-array", new byte[]{0, 1, 2, 3, 4});
        ByteBuffer binaryBuffer = ByteBuffer.wrap(new byte[]{5, 6, 7, 8, 9});
        row.addBinary("binary-bytebuffer", binaryBuffer);
        row.setNull("null");
        row.addDecimal("decimal", BigDecimal.valueOf(12345L, 3));
        return row;
    }

    public static PartialRow getPartialRowWithAllTypes() {
        return ClientTestUtil.getPartialRowWithAllTypes(null, (byte)42);
    }

    public static CreateTableOptions getAllTypesCreateTableOptions() {
        return new CreateTableOptions().setRangePartitionColumns(ImmutableList.of("int8"));
    }

    public static Schema getBasicSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(5);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.INT32).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column1_i", Type.INT32).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column2_i", Type.INT32).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column3_s", Type.STRING).nullable(true).desiredBlockSize(4096).encoding(ColumnSchema.Encoding.DICT_ENCODING).compressionAlgorithm(ColumnSchema.CompressionAlgorithm.LZ4).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column4_b", Type.BOOL).build());
        return new Schema(columns);
    }

    public static CreateTableOptions getBasicCreateTableOptions() {
        return new CreateTableOptions().setRangePartitionColumns(ImmutableList.of("key"));
    }

    public static CreateTableOptions getBasicTableOptionsWithNonCoveredRange() {
        Schema schema = ClientTestUtil.getBasicSchema();
        CreateTableOptions option = new CreateTableOptions();
        option.setRangePartitionColumns(ImmutableList.of("key"));
        PartialRow lowerBoundA = schema.newPartialRow();
        lowerBoundA.addInt("key", 0);
        PartialRow upperBoundA = schema.newPartialRow();
        upperBoundA.addInt("key", 100);
        option.addRangePartition(lowerBoundA, upperBoundA);
        PartialRow lowerBoundB = schema.newPartialRow();
        lowerBoundB.addInt("key", 200);
        PartialRow upperBoundB = schema.newPartialRow();
        upperBoundB.addInt("key", 300);
        option.addRangePartition(lowerBoundB, upperBoundB);
        PartialRow split = schema.newPartialRow();
        split.addInt("key", 50);
        option.addSplitRow(split);
        return option;
    }

    public static KuduTable createDefaultTable(KuduClient client, String tableName) throws KuduException {
        return client.createTable(tableName, ClientTestUtil.getBasicSchema(), ClientTestUtil.getBasicCreateTableOptions());
    }

    public static void loadDefaultTable(KuduClient client, String tableName, int numRows) throws KuduException {
        KuduTable table = client.openTable(tableName);
        KuduSession session = client.newSession();
        for (int i = 0; i < numRows; ++i) {
            Insert insert = ClientTestUtil.createBasicSchemaInsert(table, i);
            session.apply(insert);
        }
        session.flush();
        session.close();
    }

    public static Upsert createBasicSchemaUpsert(KuduTable table, int key) {
        Upsert upsert = table.newUpsert();
        PartialRow row = upsert.getRow();
        row.addInt(0, key);
        row.addInt(1, 3);
        row.addInt(2, 4);
        row.addString(3, "another string");
        row.addBoolean(4, false);
        return upsert;
    }

    public static Upsert createBasicSchemaUpsertWithDataSize(KuduTable table, int key, int dataSize) {
        Upsert upsert = table.newUpsert();
        PartialRow row = upsert.getRow();
        row.addInt(0, key);
        row.addInt(1, 3);
        row.addInt(2, 4);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < dataSize; ++i) {
            builder.append("*");
        }
        String val = builder.toString();
        row.addString(3, val);
        row.addBoolean(4, false);
        return upsert;
    }

    public static Insert createBasicSchemaInsert(KuduTable table, int key) {
        Insert insert = table.newInsert();
        PartialRow row = insert.getRow();
        row.addInt(0, key);
        row.addInt(1, 2);
        row.addInt(2, 3);
        row.addString(3, "a string");
        row.addBoolean(4, true);
        return insert;
    }

    public static KuduTable createFourTabletsTableWithNineRows(AsyncKuduClient client, String tableName, long timeoutMs) throws Exception {
        int[] KEYS = new int[]{10, 20, 30};
        Schema basicSchema = ClientTestUtil.getBasicSchema();
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        for (int i : KEYS) {
            PartialRow splitRow = basicSchema.newPartialRow();
            splitRow.addInt(0, i);
            builder.addSplitRow(splitRow);
        }
        KuduTable table = client.syncClient().createTable(tableName, basicSchema, builder);
        AsyncKuduSession session = client.newSession();
        for (int key1 : KEYS) {
            for (int key2 = 1; key2 <= 3; ++key2) {
                Insert insert = table.newInsert();
                PartialRow row = insert.getRow();
                row.addInt(0, key1 + key2);
                row.addInt(1, key1);
                row.addInt(2, key2);
                row.addString(3, "a string");
                row.addBoolean(4, true);
                session.apply(insert).join(timeoutMs);
            }
        }
        session.close().join(timeoutMs);
        return table;
    }

    public static KuduTable createTableWithOneThousandRows(AsyncKuduClient client, String tableName, int rowDataSize, long timeoutMs) throws Exception {
        int[] KEYS = new int[]{250, 500, 750};
        Schema basicSchema = ClientTestUtil.getBasicSchema();
        CreateTableOptions builder = ClientTestUtil.getBasicCreateTableOptions();
        for (int i : KEYS) {
            PartialRow splitRow = basicSchema.newPartialRow();
            splitRow.addInt(0, i);
            builder.addSplitRow(splitRow);
        }
        KuduTable table = client.syncClient().createTable(tableName, basicSchema, builder);
        AsyncKuduSession session = client.newSession();
        for (int key = 0; key < 1000; ++key) {
            Upsert upsert = ClientTestUtil.createBasicSchemaUpsertWithDataSize(table, key, rowDataSize);
            session.apply(upsert).join(timeoutMs);
        }
        session.close().join(timeoutMs);
        return table;
    }

    public static Schema createManyVarcharsSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes(10)).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes(10)).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c2", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes(10)).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c3", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes(10)).nullable(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c4", Type.VARCHAR).typeAttributes(CharUtil.typeAttributes(10)).nullable(true).build());
        return new Schema(columns);
    }

    public static Schema createManyStringsSchema() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(4);
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.STRING).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.STRING).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c2", Type.STRING).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c3", Type.STRING).nullable(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c4", Type.STRING).nullable(true).build());
        return new Schema(columns);
    }

    public static Schema createSchemaWithBinaryColumns() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.BINARY).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.STRING).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c2", Type.DOUBLE).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c3", Type.BINARY).nullable(true).build());
        return new Schema(columns);
    }

    public static Schema createSchemaWithTimestampColumns() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.UNIXTIME_MICROS).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.UNIXTIME_MICROS).nullable(true).build());
        return new Schema(columns);
    }

    public static Schema createSchemaWithDateColumns() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.DATE).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.DATE).nullable(true).build());
        return new Schema(columns);
    }

    public static Schema createSchemaWithDecimalColumns() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.DECIMAL).key(true).typeAttributes(new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(18).build()).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.DECIMAL).nullable(true).typeAttributes(new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(38).build()).build());
        return new Schema(columns);
    }

    public static Schema createSchemaWithImmutableColumns() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(ClientTestUtil.getBasicSchema().getColumns());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("column5_i", Type.INT32).nullable(true).immutable(true).build());
        return new Schema(columns);
    }

    public static Schema createSchemaWithNonUniqueKey() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.INT32).nonUniqueKey(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("c1", Type.INT32).nullable(true).build());
        return new Schema(columns);
    }

    public static Schema createSchemaWithArrayColumns() {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        columns.add(new ColumnSchema.ColumnSchemaBuilder("key", Type.INT32).key(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("int_arr", Type.INT32).array(true).nullable(false).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("nullable_int_arr", Type.INT32).array(true).nullable(true).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("dec_arr", Type.DECIMAL).array(true).nullable(true).typeAttributes(new ColumnTypeAttributes.ColumnTypeAttributesBuilder().precision(10).scale(2).build()).build());
        columns.add(new ColumnSchema.ColumnSchemaBuilder("str_arr", Type.STRING).array(true).nullable(true).build());
        return new Schema(columns);
    }
}

