/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.Random;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.shaded.com.google.common.base.Throwables;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class CapturingLogAppender
extends AbstractAppender {
    private static final PatternLayout LAYOUT = PatternLayout.newBuilder().withPattern("%d{HH:mm:ss.SSS} [%p - %t] (%F:%L) %m%n").build();
    private static final Random RANDOM = new Random();
    @GuardedBy(value="this")
    private StringBuilder appended = new StringBuilder();

    public CapturingLogAppender() {
        super(String.format("CapturingToFileLogAppender-%d", RANDOM.nextInt()), null, (Layout)LAYOUT, true, Property.EMPTY_ARRAY);
        this.start();
    }

    public synchronized void append(LogEvent event) {
        this.appended.append(this.getLayout().toSerializable(event));
        if (event.getThrown() != null) {
            this.appended.append(Throwables.getStackTraceAsString(event.getThrown()));
            this.appended.append("\n");
        }
    }

    public synchronized String getAppendedText() {
        return this.appended.toString();
    }

    public Closeable attach() {
        LoggerContext.getContext((boolean)false).getRootLogger().addAppender((Appender)this);
        return new Closeable(){

            @Override
            public void close() throws IOException {
                LoggerContext.getContext((boolean)false).getRootLogger().removeAppender((Appender)CapturingLogAppender.this);
            }
        };
    }
}

