/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.org.apache.http.auth;

import org.apache.kudu.shaded.org.apache.http.annotation.Contract;
import org.apache.kudu.shaded.org.apache.http.annotation.ThreadingBehavior;
import org.apache.kudu.shaded.org.apache.http.auth.AuthScheme;
import org.apache.kudu.shaded.org.apache.http.auth.Credentials;
import org.apache.kudu.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class AuthOption {
    private final AuthScheme authScheme;
    private final Credentials creds;

    public AuthOption(AuthScheme authScheme, Credentials creds) {
        Args.notNull(authScheme, "Auth scheme");
        Args.notNull(creds, "User credentials");
        this.authScheme = authScheme;
        this.creds = creds;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public Credentials getCredentials() {
        return this.creds;
    }

    public String toString() {
        return this.authScheme.toString();
    }
}

