/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu;

import java.util.Arrays;
import java.util.List;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Common;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.util.DecimalUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public enum Type {
    INT8(Common.DataType.INT8, "int8"),
    INT16(Common.DataType.INT16, "int16"),
    INT32(Common.DataType.INT32, "int32"),
    INT64(Common.DataType.INT64, "int64"),
    BINARY(Common.DataType.BINARY, "binary"),
    STRING(Common.DataType.STRING, "string"),
    BOOL(Common.DataType.BOOL, "bool"),
    FLOAT(Common.DataType.FLOAT, "float"),
    DOUBLE(Common.DataType.DOUBLE, "double"),
    UNIXTIME_MICROS(Common.DataType.UNIXTIME_MICROS, "unixtime_micros"),
    DECIMAL(Arrays.asList(Common.DataType.DECIMAL32, Common.DataType.DECIMAL64, Common.DataType.DECIMAL128), "decimal"),
    VARCHAR(Common.DataType.VARCHAR, "varchar"),
    DATE(Common.DataType.DATE, "date"),
    NESTED(Common.DataType.NESTED, "nested");

    private final ImmutableList<Common.DataType> dataTypes;
    private final String name;
    private final int size;

    private Type(Common.DataType dataType, String name) {
        this.dataTypes = ImmutableList.of(dataType);
        this.name = name;
        this.size = Type.getTypeSize(dataType);
    }

    private Type(List<Common.DataType> dataTypes, String name) {
        this.dataTypes = ImmutableList.copyOf(dataTypes);
        this.name = name;
        this.size = -1;
    }

    @Deprecated
    public Common.DataType getDataType() {
        if (this == DECIMAL) {
            throw new IllegalStateException("Please use the newer getDataType(ColumnTypeAttributes) to support the Decimal data type");
        }
        return (Common.DataType)this.dataTypes.get(0);
    }

    public Common.DataType getDataType(ColumnTypeAttributes typeAttributes) {
        if (this == DECIMAL) {
            return DecimalUtil.precisionToDataType(typeAttributes.getPrecision());
        }
        return (Common.DataType)this.dataTypes.get(0);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public int getSize() {
        if (this == DECIMAL) {
            throw new IllegalStateException("Please use the newer getSize(ColumnTypeAttributes) to support the Decimal data type");
        }
        return this.size;
    }

    public int getSize(ColumnTypeAttributes typeAttributes) {
        if (this == DECIMAL) {
            return DecimalUtil.precisionToSize(typeAttributes.getPrecision());
        }
        return this.size;
    }

    public String toString() {
        return "Type: " + this.name;
    }

    private static int getTypeSize(Common.DataType type) {
        switch (type) {
            case STRING: 
            case BINARY: 
            case VARCHAR: 
            case NESTED: {
                return 16;
            }
            case BOOL: 
            case INT8: 
            case IS_DELETED: {
                return 1;
            }
            case INT16: {
                return 2;
            }
            case INT32: 
            case DATE: 
            case FLOAT: {
                return 4;
            }
            case INT64: 
            case DOUBLE: 
            case UNIXTIME_MICROS: {
                return 8;
            }
        }
        throw new IllegalArgumentException("the provided data type doesn't map to any known one");
    }

    public static Type getTypeForDataType(Common.DataType type) {
        switch (type) {
            case STRING: {
                return STRING;
            }
            case BINARY: {
                return BINARY;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case BOOL: 
            case IS_DELETED: {
                return BOOL;
            }
            case INT8: {
                return INT8;
            }
            case INT16: {
                return INT16;
            }
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case UNIXTIME_MICROS: {
                return UNIXTIME_MICROS;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: {
                return DATE;
            }
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: {
                return DECIMAL;
            }
            case NESTED: {
                return NESTED;
            }
        }
        throw new IllegalArgumentException("the provided data type doesn't map to any known one: " + type.getDescriptorForType().getFullName());
    }

    public static Type getTypeForName(String name) {
        for (Type t : Type.values()) {
            if (!t.name().equals(name) && !t.getName().equals(name)) continue;
            return t;
        }
        throw new IllegalArgumentException("The provided name doesn't map to any known type: " + name);
    }

    public boolean isFixedSize() {
        return this != BINARY && this != STRING && this != VARCHAR;
    }
}

