/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Common;
import org.apache.kudu.RowOperations;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.HostAndPort;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionSchema;
import org.apache.kudu.client.RangePartition;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.util.DateUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ProtobufHelper {
    public static List<Common.ColumnSchemaPB> schemaToListPb(Schema schema) {
        return ProtobufHelper.schemaToListPb(schema, EnumSet.noneOf(SchemaPBConversionFlags.class));
    }

    public static List<Common.ColumnSchemaPB> schemaToListPb(Schema schema, EnumSet<SchemaPBConversionFlags> flags) {
        ArrayList<Common.ColumnSchemaPB> columns = new ArrayList<Common.ColumnSchemaPB>(schema.getColumnCount());
        Common.ColumnSchemaPB.Builder schemaBuilder = Common.ColumnSchemaPB.newBuilder();
        for (ColumnSchema col : schema.getColumns()) {
            int id = schema.hasColumnIds() ? schema.getColumnId(col.getName()) : -1;
            columns.add(ProtobufHelper.columnToPb(schemaBuilder, id, col, flags));
            schemaBuilder.clear();
        }
        return columns;
    }

    public static Common.SchemaPB schemaToPb(Schema schema) {
        return ProtobufHelper.schemaToPb(schema, EnumSet.noneOf(SchemaPBConversionFlags.class));
    }

    public static Common.SchemaPB schemaToPb(Schema schema, EnumSet<SchemaPBConversionFlags> flags) {
        Common.SchemaPB.Builder builder = Common.SchemaPB.newBuilder();
        builder.addAllColumns(ProtobufHelper.schemaToListPb(schema, flags));
        return builder.build();
    }

    public static Common.ColumnSchemaPB columnToPb(ColumnSchema column) {
        return ProtobufHelper.columnToPb(Common.ColumnSchemaPB.newBuilder(), -1, column);
    }

    public static Common.ColumnSchemaPB columnToPb(Common.ColumnSchemaPB.Builder schemaBuilder, int colId, ColumnSchema column) {
        return ProtobufHelper.columnToPb(schemaBuilder, colId, column, EnumSet.noneOf(SchemaPBConversionFlags.class));
    }

    public static Common.ColumnSchemaPB columnToPb(Common.ColumnSchemaPB.Builder schemaBuilder, int colId, ColumnSchema column, EnumSet<SchemaPBConversionFlags> flags) {
        schemaBuilder.setName(column.getName()).setType(column.getWireType()).setIsKey(column.isKey()).setIsNullable(column.isNullable()).setImmutable(column.isImmutable()).setIsAutoIncrementing(column.isAutoIncrementing()).setCfileBlockSize(column.getDesiredBlockSize());
        if (!flags.contains((Object)SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID) && colId >= 0) {
            schemaBuilder.setId(colId);
        }
        if (column.getEncoding() != null) {
            schemaBuilder.setEncoding(column.getEncoding().getInternalPbType());
        }
        if (column.getCompressionAlgorithm() != null) {
            schemaBuilder.setCompression(column.getCompressionAlgorithm().getInternalPbType());
        }
        if (column.getDefaultValue() != null) {
            schemaBuilder.setReadDefaultValue(UnsafeByteOperations.unsafeWrap(ProtobufHelper.objectToWireFormat(column, column.getDefaultValue())));
        }
        if (column.getTypeAttributes() != null) {
            schemaBuilder.setTypeAttributes(ProtobufHelper.columnTypeAttributesToPb(Common.ColumnTypeAttributesPB.newBuilder(), column));
        }
        if (!flags.contains((Object)SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_COMMENT) && !column.getComment().isEmpty()) {
            schemaBuilder.setComment(column.getComment());
        }
        if (column.isArray()) {
            ColumnSchema.NestedTypeDescriptor nested = column.getNestedTypeDescriptor();
            Preconditions.checkState(nested == null || nested.isArray(), "Column reports isArray() but nested descriptor is not ARRAY");
            ColumnSchema.ArrayTypeDescriptor arr = nested.getArrayDescriptor();
            Type elemType = arr.getElemType();
            Common.NestedDataTypePB.ArrayTypeDescriptor.Builder arrPb = Common.NestedDataTypePB.ArrayTypeDescriptor.newBuilder();
            Common.DataType elemPbType = elemType.getDataType(column.getTypeAttributes());
            arrPb.setType(elemPbType);
            Common.NestedDataTypePB.Builder nestedPb = Common.NestedDataTypePB.newBuilder();
            nestedPb.setArray(arrPb);
            schemaBuilder.setNestedType(nestedPb);
        }
        return schemaBuilder.build();
    }

    public static Common.ColumnTypeAttributesPB columnTypeAttributesToPb(Common.ColumnTypeAttributesPB.Builder builder, ColumnSchema column) {
        ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
        if (typeAttributes.hasPrecision()) {
            builder.setPrecision(typeAttributes.getPrecision());
        }
        if (typeAttributes.hasScale()) {
            builder.setScale(typeAttributes.getScale());
        }
        if (typeAttributes.hasLength()) {
            builder.setLength(typeAttributes.getLength());
        }
        return builder.build();
    }

    public static ColumnSchema pbToColumnSchema(Common.ColumnSchemaPB pb) {
        return ProtobufHelper.pbToColumnSchema(pb, true);
    }

    public static ColumnSchema pbToColumnSchema(Common.ColumnSchemaPB pb, boolean isKeyUnique) {
        Object defaultValue;
        ColumnSchema.ColumnSchemaBuilder csb;
        ColumnTypeAttributes typeAttributes;
        ColumnSchema.Encoding encoding = ColumnSchema.Encoding.valueOf(pb.getEncoding().name());
        ColumnSchema.CompressionAlgorithm compressionAlgorithm = ColumnSchema.CompressionAlgorithm.valueOf(pb.getCompression().name());
        int desiredBlockSize = pb.getCfileBlockSize();
        if (pb.getIsAutoIncrementing()) {
            return new ColumnSchema.AutoIncrementingColumnSchemaBuilder().encoding(encoding).compressionAlgorithm(compressionAlgorithm).desiredBlockSize(desiredBlockSize).comment(pb.getComment()).build();
        }
        ColumnTypeAttributes columnTypeAttributes = typeAttributes = pb.hasTypeAttributes() ? ProtobufHelper.pbToColumnTypeAttributes(pb.getTypeAttributes()) : null;
        if (pb.hasNestedType() && pb.getNestedType().hasArray()) {
            Common.NestedDataTypePB.ArrayTypeDescriptor arrPb = pb.getNestedType().getArray();
            Type elemType = Type.getTypeForDataType(arrPb.getType());
            csb = new ColumnSchema.ColumnSchemaBuilder(pb.getName(), elemType);
            csb.array(true);
            defaultValue = pb.hasWriteDefaultValue() ? ProtobufHelper.byteStringToObject(elemType, typeAttributes, pb.getWriteDefaultValue()) : null;
        } else {
            Type type = Type.getTypeForDataType(pb.getType());
            csb = new ColumnSchema.ColumnSchemaBuilder(pb.getName(), type);
            Object object = defaultValue = pb.hasWriteDefaultValue() ? ProtobufHelper.byteStringToObject(type, typeAttributes, pb.getWriteDefaultValue()) : null;
        }
        if (pb.getIsKey() && isKeyUnique) {
            csb.key(true);
        } else {
            csb.nonUniqueKey(pb.getIsKey());
        }
        return csb.nullable(pb.getIsNullable()).immutable(pb.getImmutable()).defaultValue(defaultValue).encoding(encoding).compressionAlgorithm(compressionAlgorithm).desiredBlockSize(desiredBlockSize).typeAttributes(typeAttributes).comment(pb.getComment()).build();
    }

    public static ColumnTypeAttributes pbToColumnTypeAttributes(Common.ColumnTypeAttributesPB pb) {
        ColumnTypeAttributes.ColumnTypeAttributesBuilder builder = new ColumnTypeAttributes.ColumnTypeAttributesBuilder();
        if (pb.hasPrecision()) {
            builder.precision(pb.getPrecision());
        }
        if (pb.hasScale()) {
            builder.scale(pb.getScale());
        }
        if (pb.hasLength()) {
            builder.length(pb.getLength());
        }
        return builder.build();
    }

    public static Schema pbToSchema(Common.SchemaPB schema) {
        boolean hasAutoIncrementing = false;
        for (Common.ColumnSchemaPB columnPb : schema.getColumnsList()) {
            if (!columnPb.getIsAutoIncrementing()) continue;
            hasAutoIncrementing = true;
            break;
        }
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(schema.getColumnsCount());
        ArrayList<Integer> columnIds = new ArrayList<Integer>(schema.getColumnsCount());
        for (Common.ColumnSchemaPB columnPb : schema.getColumnsList()) {
            columns.add(ProtobufHelper.pbToColumnSchema(columnPb, !hasAutoIncrementing));
            int id = columnPb.getId();
            if (id < 0) {
                throw new IllegalArgumentException("Illegal column ID: " + id);
            }
            columnIds.add(id);
        }
        return new Schema(columns, columnIds);
    }

    public static PartitionSchema pbToPartitionSchema(Common.PartitionSchemaPB pb, Schema schema) {
        List<Integer> rangeColumns = ProtobufHelper.pbToIds(pb.getRangeSchema().getColumnsList());
        PartitionSchema.RangeSchema rangeSchema = new PartitionSchema.RangeSchema(rangeColumns);
        ImmutableList.Builder hashSchemas = ImmutableList.builder();
        for (Common.PartitionSchemaPB.HashBucketSchemaPB hashBucketSchemaPB : pb.getHashSchemaList()) {
            List<Integer> hashColumnIds = ProtobufHelper.pbToIds(hashBucketSchemaPB.getColumnsList());
            PartitionSchema.HashBucketSchema hashSchema = new PartitionSchema.HashBucketSchema(hashColumnIds, hashBucketSchemaPB.getNumBuckets(), hashBucketSchemaPB.getSeed());
            hashSchemas.add(hashSchema);
        }
        ImmutableList.Builder rangesWithHashSchemas = ImmutableList.builder();
        for (Common.PartitionSchemaPB.RangeWithHashSchemaPB rhsPB : pb.getCustomHashSchemaRangesList()) {
            ArrayList<PartitionSchema.HashBucketSchema> rangeHashSchemas = new ArrayList<PartitionSchema.HashBucketSchema>();
            for (Common.PartitionSchemaPB.HashBucketSchemaPB hbs : rhsPB.getHashSchemaList()) {
                rangeHashSchemas.add(new PartitionSchema.HashBucketSchema(ProtobufHelper.pbToIds(hbs.getColumnsList()), hbs.getNumBuckets(), hbs.getSeed()));
            }
            Operation.OperationsDecoder dec = new Operation.OperationsDecoder();
            RowOperations.RowOperationsPB rangeBounds = rhsPB.getRangeBounds();
            List<RangePartition> partitions = dec.decodeRangePartitions(rangeBounds, schema);
            if (partitions.size() != 1) {
                throw new IllegalArgumentException("unexpected range bounds");
            }
            RangePartition p = partitions.get(0);
            PartitionSchema.RangeWithHashSchema rhs = new PartitionSchema.RangeWithHashSchema(p.lowerBound, p.upperBound, rangeHashSchemas);
            rangesWithHashSchemas.add(rhs);
        }
        return new PartitionSchema(rangeSchema, (List<PartitionSchema.HashBucketSchema>)((Object)hashSchemas.build()), (List<PartitionSchema.RangeWithHashSchema>)((Object)rangesWithHashSchemas.build()), schema);
    }

    public static Common.PartitionSchemaPB partitionSchemaToPb(PartitionSchema partitionSchema) {
        Common.PartitionSchemaPB.Builder builder = Common.PartitionSchemaPB.newBuilder();
        for (PartitionSchema.HashBucketSchema hashBucketSchema : partitionSchema.getHashBucketSchemas()) {
            Common.PartitionSchemaPB.HashBucketSchemaPB.Builder hbsBuilder = Common.PartitionSchemaPB.HashBucketSchemaPB.newBuilder().addAllColumns(ProtobufHelper.idsToPb(hashBucketSchema.getColumnIds())).setNumBuckets(hashBucketSchema.getNumBuckets()).setSeed(hashBucketSchema.getSeed());
            builder.addHashSchema(hbsBuilder.build());
        }
        Common.PartitionSchemaPB.RangeSchemaPB rangeSchemaPB = Common.PartitionSchemaPB.RangeSchemaPB.newBuilder().addAllColumns(ProtobufHelper.idsToPb(partitionSchema.getRangeSchema().getColumnIds())).build();
        builder.setRangeSchema(rangeSchemaPB);
        for (PartitionSchema.RangeWithHashSchema rhs : partitionSchema.getRangesWithHashSchemas()) {
            Common.PartitionSchemaPB.RangeWithHashSchemaPB.Builder rhsBuilder = Common.PartitionSchemaPB.RangeWithHashSchemaPB.newBuilder();
            for (PartitionSchema.HashBucketSchema hbs : rhs.hashSchemas) {
                Common.PartitionSchemaPB.HashBucketSchemaPB.Builder hbsBuilder = Common.PartitionSchemaPB.HashBucketSchemaPB.newBuilder().addAllColumns(ProtobufHelper.idsToPb(hbs.getColumnIds())).setNumBuckets(hbs.getNumBuckets()).setSeed(hbs.getSeed());
                rhsBuilder.addHashSchema(hbsBuilder.build());
            }
            rhsBuilder.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(rhs.lowerBound, rhs.upperBound, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND));
            builder.addCustomHashSchemaRanges(rhsBuilder.build());
        }
        return builder.build();
    }

    static Partition pbToPartition(Common.PartitionPB pb) {
        return new Partition(pb.getPartitionKeyStart().toByteArray(), pb.getPartitionKeyEnd().toByteArray(), pb.getHashBucketsList());
    }

    static Common.PartitionPB partitionToPb(Partition partition) {
        return Common.PartitionPB.newBuilder().setPartitionKeyStart(ByteString.copyFrom(partition.getPartitionKeyStart())).setPartitionKeyEnd(ByteString.copyFrom(partition.getPartitionKeyEnd())).addAllHashBuckets(partition.getHashBuckets()).build();
    }

    private static List<Integer> pbToIds(List<Common.PartitionSchemaPB.ColumnIdentifierPB> columnIdentifiers) {
        ImmutableList.Builder columnIds = ImmutableList.builder();
        block5: for (Common.PartitionSchemaPB.ColumnIdentifierPB column : columnIdentifiers) {
            switch (column.getIdentifierCase()) {
                case ID: {
                    columnIds.add((Object)column.getId());
                    continue block5;
                }
                case NAME: {
                    throw new IllegalArgumentException(String.format("Expected column ID from master: %s", column));
                }
                case IDENTIFIER_NOT_SET: {
                    throw new IllegalArgumentException("Unknown column: " + column);
                }
            }
            throw new IllegalArgumentException("Unknown identifier type!");
        }
        return columnIds.build();
    }

    private static List<Common.PartitionSchemaPB.ColumnIdentifierPB> idsToPb(List<Integer> columnIds) {
        ImmutableList.Builder columnIdentifiers = ImmutableList.builder();
        for (Integer id : columnIds) {
            Common.PartitionSchemaPB.ColumnIdentifierPB columnIdentifierPB = Common.PartitionSchemaPB.ColumnIdentifierPB.newBuilder().setId(id).build();
            columnIdentifiers.add(columnIdentifierPB);
        }
        return columnIdentifiers.build();
    }

    private static byte[] objectToWireFormat(ColumnSchema col, Object value) {
        switch (col.getType()) {
            case BOOL: {
                return Bytes.fromBoolean((Boolean)value);
            }
            case INT8: {
                return new byte[]{(Byte)value};
            }
            case INT16: {
                return Bytes.fromShort((Short)value);
            }
            case DATE: {
                return Bytes.fromInt(DateUtil.sqlDateToEpochDays((Date)value));
            }
            case INT32: {
                return Bytes.fromInt((Integer)value);
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                return Bytes.fromLong((Long)value);
            }
            case VARCHAR: 
            case STRING: {
                return ((String)value).getBytes(StandardCharsets.UTF_8);
            }
            case BINARY: {
                return (byte[])value;
            }
            case FLOAT: {
                return Bytes.fromFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Bytes.fromDouble((Double)value);
            }
            case DECIMAL: {
                return Bytes.fromBigDecimal((BigDecimal)value, col.getTypeAttributes().getPrecision());
            }
        }
        throw new IllegalArgumentException("The column " + col.getName() + " is of type " + (Object)((Object)col.getType()) + " which is unknown");
    }

    private static Object byteStringToObject(Type type, ColumnTypeAttributes typeAttributes, ByteString value) {
        ByteBuffer buf = value.asReadOnlyByteBuffer();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case BOOL: {
                return buf.get() != 0;
            }
            case INT8: {
                return buf.get();
            }
            case INT16: {
                return buf.getShort();
            }
            case DATE: {
                return DateUtil.epochDaysToSqlDate(buf.getInt());
            }
            case INT32: {
                return buf.getInt();
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                return buf.getLong();
            }
            case FLOAT: {
                return Float.valueOf(buf.getFloat());
            }
            case DOUBLE: {
                return buf.getDouble();
            }
            case VARCHAR: 
            case STRING: {
                return value.toStringUtf8();
            }
            case BINARY: {
                return value.toByteArray();
            }
            case DECIMAL: {
                return Bytes.getDecimal(value.toByteArray(), typeAttributes.getPrecision(), typeAttributes.getScale());
            }
        }
        throw new IllegalArgumentException("This type is unknown: " + (Object)((Object)type));
    }

    protected static ByteString objectToByteStringNoType(String colName, Object value) {
        byte[] bytes;
        if (value instanceof Boolean) {
            bytes = Bytes.fromBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            bytes = new byte[]{(Byte)value};
        } else if (value instanceof Short) {
            bytes = Bytes.fromShort((Short)value);
        } else if (value instanceof Integer) {
            bytes = Bytes.fromInt((Integer)value);
        } else if (value instanceof Long) {
            bytes = Bytes.fromLong((Long)value);
        } else if (value instanceof String) {
            bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
        } else if (value instanceof byte[]) {
            bytes = (byte[])value;
        } else if (value instanceof ByteBuffer) {
            bytes = ((ByteBuffer)value).array();
        } else if (value instanceof Float) {
            bytes = Bytes.fromFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            bytes = Bytes.fromDouble((Double)value);
        } else if (value instanceof BigDecimal) {
            bytes = Bytes.fromBigDecimal((BigDecimal)value, 38);
        } else {
            throw new IllegalArgumentException("The default value provided for column " + colName + " is of class " + value.getClass().getName() + " which does not map to a supported Kudu type");
        }
        return UnsafeByteOperations.unsafeWrap(bytes);
    }

    public static Common.HostPortPB hostAndPortToPB(HostAndPort hostAndPort) {
        return Common.HostPortPB.newBuilder().setHost(hostAndPort.getHost()).setPort(hostAndPort.getPort()).build();
    }

    public static HostAndPort hostAndPortFromPB(Common.HostPortPB hostPortPB) {
        return new HostAndPort(hostPortPB.getHost(), hostPortPB.getPort());
    }

    public static String hostPortPbListToString(List<Common.HostPortPB> pbs) {
        ArrayList<String> strs = new ArrayList<String>(pbs.size());
        for (Common.HostPortPB pb : pbs) {
            strs.add(pb.getHost() + ":" + pb.getPort());
        }
        return Joiner.on(',').join(strs);
    }

    public static enum SchemaPBConversionFlags {
        SCHEMA_PB_WITHOUT_COMMENT,
        SCHEMA_PB_WITHOUT_ID;

    }
}

