/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.kudu.Schema;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.common.primitives.UnsignedBytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Impala"})
@InterfaceStability.Unstable
public class PartitionSchema {
    private static final Comparator<EncodedRangeBoundsWithHashSchema> COMPARATOR = new BoundsComparator();
    private final RangeSchema rangeSchema;
    private final List<HashBucketSchema> hashBucketSchemas;
    private final List<RangeWithHashSchema> rangesWithHashSchemas;
    private final List<EncodedRangeBoundsWithHashSchema> encodedRangesWithHashSchemas;
    private TreeSet<EncodedRangeBoundsWithHashSchema> hashSchemasPerRange;
    private final boolean isSimple;

    public PartitionSchema(RangeSchema rangeSchema, List<HashBucketSchema> hashBucketSchemas, List<RangeWithHashSchema> rangesWithHashSchemas, Schema schema) {
        boolean isSimple;
        this.rangeSchema = rangeSchema;
        this.hashBucketSchemas = hashBucketSchemas;
        this.rangesWithHashSchemas = rangesWithHashSchemas;
        this.hashSchemasPerRange = new TreeSet<EncodedRangeBoundsWithHashSchema>(COMPARATOR);
        this.encodedRangesWithHashSchemas = new ArrayList<EncodedRangeBoundsWithHashSchema>(rangesWithHashSchemas.size());
        for (RangeWithHashSchema rhs : this.rangesWithHashSchemas) {
            boolean isUpperBoundEmpty;
            byte[] upper;
            boolean isLowerBoundEmpty = rhs.lowerBound == null || rhs.lowerBound.getColumnsBitSet().isEmpty();
            byte[] lower = isLowerBoundEmpty ? new byte[]{} : KeyEncoder.encodeRangePartitionKey(rhs.lowerBound, this.rangeSchema);
            if (this.hashSchemasPerRange.add(new EncodedRangeBoundsWithHashSchema(lower, upper = (isUpperBoundEmpty = rhs.upperBound == null || rhs.upperBound.getColumnsBitSet().isEmpty()) ? new byte[]{} : KeyEncoder.encodeRangePartitionKey(rhs.upperBound, this.rangeSchema), rhs.hashSchemas))) continue;
            throw new IllegalArgumentException(rhs.lowerBound.toString() + ": duplicate lower range boundary");
        }
        this.encodedRangesWithHashSchemas.addAll(this.hashSchemasPerRange);
        boolean bl = isSimple = rangesWithHashSchemas.isEmpty() && hashBucketSchemas.isEmpty() && rangeSchema.columns.size() == schema.getPrimaryKeyColumnCount();
        if (isSimple) {
            int i = 0;
            for (Integer id : rangeSchema.columns) {
                if (schema.getColumnIndex(id) == i++) continue;
                isSimple = false;
                break;
            }
        }
        this.isSimple = isSimple;
    }

    public PartitionSchema(RangeSchema rangeSchema, List<HashBucketSchema> hashBucketSchemas, Schema schema) {
        this(rangeSchema, hashBucketSchemas, ImmutableList.of(), schema);
    }

    public byte[] encodePartitionKey(PartialRow row) {
        return KeyEncoder.encodePartitionKey(row, this);
    }

    public RangeSchema getRangeSchema() {
        return this.rangeSchema;
    }

    public List<HashBucketSchema> getHashBucketSchemas() {
        return this.hashBucketSchemas;
    }

    public List<RangeWithHashSchema> getRangesWithHashSchemas() {
        return this.rangesWithHashSchemas;
    }

    List<EncodedRangeBoundsWithHashSchema> getEncodedRangesWithHashSchemas() {
        return this.encodedRangesWithHashSchemas;
    }

    boolean isSimpleRangePartitioning() {
        return this.isSimple;
    }

    boolean hasCustomHashSchemas() {
        return !this.rangesWithHashSchemas.isEmpty();
    }

    List<HashBucketSchema> getHashSchemaForRange(byte[] rangeKey) {
        if (!this.hasCustomHashSchemas()) {
            return this.hashBucketSchemas;
        }
        EncodedRangeBoundsWithHashSchema entry = this.hashSchemasPerRange.floor(new EncodedRangeBoundsWithHashSchema(rangeKey, new byte[0], ImmutableList.of()));
        if (entry == null) {
            return this.hashBucketSchemas;
        }
        byte[] upper = entry.upper;
        Preconditions.checkNotNull(upper);
        if (upper.length == 0 || Bytes.memcmp(rangeKey, upper) < 0) {
            return entry.hashSchemas;
        }
        return this.hashBucketSchemas;
    }

    public static class RangeWithHashSchema {
        public PartialRow lowerBound;
        public PartialRow upperBound;
        public List<HashBucketSchema> hashSchemas;

        public RangeWithHashSchema(PartialRow lowerBound, PartialRow upperBound, List<HashBucketSchema> hashSchemas) {
            Preconditions.checkNotNull(lowerBound);
            Preconditions.checkNotNull(upperBound);
            Preconditions.checkArgument(lowerBound.getSchema().equals(upperBound.getSchema()));
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.hashSchemas = hashSchemas;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RangeWithHashSchema)) {
                return false;
            }
            RangeWithHashSchema that = (RangeWithHashSchema)o;
            return Objects.equals(this.lowerBound, that.lowerBound) && Objects.equals(this.upperBound, that.upperBound) && Objects.equals(this.hashSchemas, that.hashSchemas);
        }

        public int hashCode() {
            return Objects.hash(this.lowerBound, this.upperBound, this.hashSchemas);
        }
    }

    public static class HashBucketSchema {
        private final List<Integer> columnIds;
        private int numBuckets;
        private int seed;

        public HashBucketSchema(List<Integer> columnIds, int numBuckets, int seed) {
            this.columnIds = columnIds;
            this.numBuckets = numBuckets;
            this.seed = seed;
        }

        public List<Integer> getColumnIds() {
            return this.columnIds;
        }

        public int getNumBuckets() {
            return this.numBuckets;
        }

        public int getSeed() {
            return this.seed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HashBucketSchema)) {
                return false;
            }
            HashBucketSchema that = (HashBucketSchema)o;
            return this.numBuckets == that.numBuckets && this.seed == that.seed && Objects.equals(this.columnIds, that.columnIds);
        }

        public int hashCode() {
            return Objects.hash(this.columnIds, this.numBuckets, this.seed);
        }
    }

    public static class RangeSchema {
        private final List<Integer> columns;

        public RangeSchema(List<Integer> columns) {
            this.columns = columns;
        }

        @Deprecated
        public List<Integer> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnIds() {
            return this.columns;
        }
    }

    static class EncodedRangeBoundsWithHashSchema {
        final byte[] lower;
        final byte[] upper;
        final List<HashBucketSchema> hashSchemas;

        public EncodedRangeBoundsWithHashSchema(byte[] lower, byte[] upper, List<HashBucketSchema> hashSchemas) {
            Preconditions.checkNotNull(lower);
            Preconditions.checkNotNull(upper);
            Preconditions.checkState(upper.length == 0 || Bytes.memcmp(lower, upper) < 0);
            this.lower = lower;
            this.upper = upper;
            this.hashSchemas = hashSchemas;
        }
    }

    private static final class BoundsComparator
    implements Comparator<EncodedRangeBoundsWithHashSchema>,
    Serializable {
        private static final long serialVersionUID = 0x80000000000001L;
        private static final Comparator<byte[]> comparator = UnsignedBytes.lexicographicalComparator();

        private BoundsComparator() {
        }

        @Override
        public int compare(EncodedRangeBoundsWithHashSchema lhs, EncodedRangeBoundsWithHashSchema rhs) {
            return comparator.compare(lhs.lower, rhs.lower);
        }
    }
}

