/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.knox.token;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.knox.token.Token;

public class Get {

    public static class Response
    extends BasicResponse {
        Response(HttpResponse response) throws IOException {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private URI requestURI;
        private HttpGet httpGetRequest;

        Request(KnoxSession session) {
            this(session, null, Collections.emptyList());
        }

        Request(KnoxSession session, String doAsUser) {
            this(session, doAsUser, Collections.emptyList());
        }

        Request(KnoxSession session, String doAsUser, List<NameValuePair> queryParameters) {
            super(session, doAsUser);
            try {
                URIBuilder uri = this.uri(Token.SERVICE_PATH);
                uri.addParameters(queryParameters);
                this.requestURI = uri.build();
            }
            catch (URISyntaxException e) {
                throw new KnoxShellException(e);
            }
        }

        public URI getRequestURI() {
            return this.requestURI;
        }

        public HttpGet getRequest() {
            return this.httpGetRequest;
        }

        @Override
        protected Callable<Response> callable() {
            return () -> {
                this.httpGetRequest = new HttpGet(this.requestURI);
                if (this.getHttpRequestConfig() != null) {
                    this.httpGetRequest.setConfig(this.getHttpRequestConfig());
                }
                return new Response((HttpResponse)this.execute((HttpRequest)this.httpGetRequest));
            };
        }
    }
}

