/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.knox.token;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.shell.knox.token.Token;
import org.apache.knox.gateway.shell.knox.token.TokenLifecycleResponse;

public abstract class AbstractTokenLifecycleRequest
extends AbstractRequest<TokenLifecycleResponse> {
    private final URI requestURI;
    private final String token;

    AbstractTokenLifecycleRequest(KnoxSession session, String token) {
        this(session, token, null);
    }

    AbstractTokenLifecycleRequest(KnoxSession session, String token, String doAsUser) {
        super(session, doAsUser);
        this.token = token;
        try {
            URIBuilder uri = this.uri(Token.SERVICE_PATH, "/", this.getOperation());
            this.requestURI = uri.build();
        }
        catch (URISyntaxException e) {
            throw new KnoxShellException(e);
        }
    }

    protected abstract String getOperation();

    protected abstract HttpEntityEnclosingRequestBase getRequest();

    public URI getRequestURI() {
        return this.requestURI;
    }

    public String getToken() {
        return this.token;
    }

    @Override
    protected Callable<TokenLifecycleResponse> callable() {
        return () -> {
            try {
                HttpEntityEnclosingRequestBase request = this.getRequest();
                if (this.getHttpRequestConfig() != null) {
                    request.setConfig(this.getHttpRequestConfig());
                }
                return new TokenLifecycleResponse((HttpResponse)this.execute((HttpRequest)request));
            }
            catch (ErrorResponse e) {
                return new TokenLifecycleResponse(e.getResponse());
            }
        };
    }
}

