/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.commands;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.groovy.groovysh.CommandSupport;
import org.apache.groovy.groovysh.Groovysh;
import org.apache.knox.gateway.shell.CredentialCollectionException;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.commands.KnoxLoginDialog;

public class LoginCommand
extends CommandSupport {
    public LoginCommand(Groovysh shell) {
        super(shell, ":login", ":lgn");
    }

    public Object execute(List<String> args) {
        KnoxSession session = null;
        KnoxLoginDialog dlg = new KnoxLoginDialog();
        try {
            dlg.collect();
            if (dlg.ok) {
                session = KnoxSession.login(args.get(0), dlg.username, new String(dlg.pass));
                this.getVariables().put("__knoxsession", session);
            }
        }
        catch (URISyntaxException | CredentialCollectionException e) {
            e.printStackTrace();
        }
        return "Session established for: " + args.get(0);
    }

    public static void main(String[] args) {
        LoginCommand cmd = new LoginCommand(new Groovysh());
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add("https://localhost:8443/gateway");
        cmd.execute(args2);
    }
}

