/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.groovy.groovysh.Groovysh;
import org.apache.knox.gateway.shell.CredentialCollectionException;
import org.apache.knox.gateway.shell.CredentialCollector;
import org.apache.knox.gateway.shell.KnoxDataSource;
import org.apache.knox.gateway.shell.commands.AbstractSQLCommandSupport;
import org.apache.knox.gateway.shell.table.KnoxShellTable;

public class DataSourceCommand
extends AbstractSQLCommandSupport {
    private static final String USAGE = ":ds (add|remove|select) [ds-name, connection-str, driver classname, authntype(none|basic)]";
    private static final String DESC = "Datasource management commands. Persisted datasources maintain connection details across sessions";

    public DataSourceCommand(Groovysh shell) {
        super(shell, ":datasources", ":ds", DESC, USAGE, DESC);
    }

    public Object execute(List<String> args) {
        Map<String, KnoxDataSource> dataSources = this.getDataSources();
        if (args.isEmpty()) {
            args.add("list");
        }
        if (args.get(0).equalsIgnoreCase("add")) {
            KnoxDataSource ds = new KnoxDataSource(args.get(1), args.get(2), args.get(3), args.get(4));
            dataSources.put(ds.getName(), ds);
            this.getVariables().put("__knoxdatasources", dataSources);
            this.persistDataSources();
        } else if (args.get(0).equalsIgnoreCase("remove")) {
            if (dataSources == null || dataSources.isEmpty()) {
                return "No datasources to remove.";
            }
            dataSources.remove(args.get(1));
            if (this.getVariables().get("__knoxdatasource") != null) {
                if (args.get(1) != null) {
                    if (((String)this.getVariables().get("__knoxdatasource")).equals(args.get(1))) {
                        System.out.println("unselecting datasource.");
                        this.getVariables().put("__knoxdatasource", "");
                    }
                } else {
                    System.out.println("Missing datasource name to remove.");
                }
            }
            this.getVariables().put("__knoxdatasources", dataSources);
            this.persistDataSources();
        } else if (!args.get(0).equalsIgnoreCase("list")) {
            if (args.get(0).equalsIgnoreCase("select")) {
                KnoxDataSource dsValue;
                block21: {
                    if (dataSources == null || dataSources.isEmpty()) {
                        return "No datasources to select from.";
                    }
                    dsValue = dataSources.get(args.get(1));
                    Connection conn = this.getConnectionFromSession(dsValue);
                    try {
                        if (conn != null && !conn.isClosed()) break block21;
                        String username = null;
                        char[] pass = null;
                        if (dsValue.getAuthnType().equalsIgnoreCase("basic")) {
                            CredentialCollector dlg;
                            try {
                                dlg = this.login();
                            }
                            catch (CredentialCollectionException e) {
                                e.printStackTrace();
                                return "Error: Credential collection failure.";
                            }
                            username = dlg.name();
                            pass = dlg.chars();
                        }
                        try {
                            this.getConnection(dsValue, username, new String(pass));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return "Error: Connection creation failure.";
                        }
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (dataSources.containsKey(args.get(1))) {
                    this.getVariables().put("__knoxdatasource", args.get(1));
                }
                KnoxShellTable datasource = new KnoxShellTable();
                datasource.title("Knox DataSource Selected");
                datasource.header("Name").header("Connect String").header("Driver").header("Authn Type");
                datasource.row().value((Comparable<? extends Object>)((Object)dsValue.getName())).value((Comparable<? extends Object>)((Object)dsValue.getConnectStr())).value((Comparable<? extends Object>)((Object)dsValue.getDriver())).value((Comparable<? extends Object>)((Object)dsValue.getAuthnType()));
                return datasource;
            }
            return "ERROR: unknown datasources command.";
        }
        return this.buildTable();
    }

    private KnoxShellTable buildTable() {
        KnoxShellTable datasource = new KnoxShellTable();
        datasource.title("Knox DataSources");
        datasource.header("Name").header("Connect String").header("Driver").header("Authn Type");
        Map dataSources = (Map)this.getVariables().get("__knoxdatasources");
        if (dataSources != null && !dataSources.isEmpty()) {
            for (KnoxDataSource dsValue : dataSources.values()) {
                datasource.row().value((Comparable<? extends Object>)((Object)dsValue.getName())).value((Comparable<? extends Object>)((Object)dsValue.getConnectStr())).value((Comparable<? extends Object>)((Object)dsValue.getDriver())).value((Comparable<? extends Object>)((Object)dsValue.getAuthnType()));
            }
        }
        return datasource;
    }

    public static void main(String[] args) {
        DataSourceCommand cmd = new DataSourceCommand(new Groovysh());
        ArrayList<String> args2 = new ArrayList<String>();
        cmd.execute(args2);
    }
}

