/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.commands;

import java.io.IOException;
import java.util.List;
import org.apache.groovy.groovysh.Groovysh;
import org.apache.knox.gateway.shell.commands.AbstractKnoxShellCommand;
import org.apache.knox.gateway.shell.table.KnoxShellTable;

public class CSVCommand
extends AbstractKnoxShellCommand {
    private static final String USAGE = ":csv [withHeaders] file-url||$variable-name [assign resulting-variable-name]";
    private static final String DESC = "Build table from CSV file located at provided URL or KnoxShell $variable-name";
    private boolean withHeaders;
    private String url;

    public CSVCommand(Groovysh shell) {
        super(shell, ":CSV", ":csv", DESC, USAGE, DESC);
    }

    public Object execute(List<String> args) {
        KnoxShellTable table = null;
        String bindVariableName = null;
        if (!args.isEmpty()) {
            bindVariableName = this.getBindingVariableNameForResultingTable(args);
        }
        if (args.get(0).contentEquals("withHeaders")) {
            this.withHeaders = true;
            this.url = args.get(1);
        } else {
            this.url = args.get(0);
        }
        try {
            if (this.withHeaders) {
                if (this.url.startsWith("$")) {
                    String csvString = (String)this.getVariables().get(this.url.substring(1));
                    table = KnoxShellTable.builder().csv().withHeaders().string(csvString);
                } else {
                    table = KnoxShellTable.builder().csv().withHeaders().url(this.url);
                }
            } else if (this.url.startsWith("$")) {
                String csvString = (String)this.getVariables().get(this.url.substring(1));
                table = KnoxShellTable.builder().csv().string(csvString);
            } else {
                table = KnoxShellTable.builder().csv().url(this.url);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (table != null && bindVariableName != null) {
            this.getVariables().put(bindVariableName, table);
        }
        return table;
    }
}

