/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.health;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.health.HealthServiceMessages;

@Path(value="/v1/ping")
public class PingResource {
    static final String VERSION_TAG = "v1";
    static final String RESOURCE_PATH = "/v1/ping";
    public static final String CONTENT = "OK";
    private static HealthServiceMessages log = (HealthServiceMessages)MessagesFactory.get(HealthServiceMessages.class);
    private static final String CONTENT_TYPE = "text/plain";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String NO_CACHE = "must-revalidate,no-cache,no-store";
    @Context
    HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Context
    ServletContext context;

    @GET
    @Produces(value={"application/json", "text/plain"})
    public Response doGet() {
        return this.getPingResponse();
    }

    @POST
    @Produces(value={"application/json", "text/plain"})
    public Response doPost() {
        return this.getPingResponse();
    }

    private Response getPingResponse() {
        this.response.setStatus(200);
        this.response.setHeader(CACHE_CONTROL, NO_CACHE);
        this.response.setContentType(CONTENT_TYPE);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (PrintWriter writer = this.response.getWriter();){
                writer.println(this.getPingContent());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            log.logException("ping", ioe);
            return Response.serverError().entity((Object)String.format(Locale.ROOT, "Failed to reply correctly due to : %s ", ioe)).build();
        }
        return Response.ok().build();
    }

    String getPingContent() {
        return CONTENT;
    }
}

