/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.health;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.servlets.MetricsServlet;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.health.HealthServiceMessages;

@Path(value="/v1/metrics")
public class MetricsResource {
    static final String VERSION_TAG = "v1";
    static final String RESOURCE_PATH = "/v1/metrics";
    private static HealthServiceMessages log = (HealthServiceMessages)MessagesFactory.get(HealthServiceMessages.class);
    public static final String RATE_UNIT = String.valueOf(MetricsServlet.class.getCanonicalName()) + ".rateUnit";
    public static final String DURATION_UNIT = String.valueOf(MetricsServlet.class.getCanonicalName()) + ".durationUnit";
    public static final String SHOW_SAMPLES = String.valueOf(MetricsServlet.class.getCanonicalName()) + ".showSamples";
    public static final String METRICS_REGISTRY = String.valueOf(MetricsServlet.class.getCanonicalName()) + ".registry";
    public static final String ALLOWED_ORIGIN = String.valueOf(MetricsServlet.class.getCanonicalName()) + ".allowedOrigin";
    private static final String CONTENT_TYPE = "application/json";
    private String allowedOrigin;
    private transient MetricRegistry registry;
    private transient ObjectMapper mapper;
    @Context
    private HttpServletRequest request;
    @Context
    private HttpServletResponse response;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() {
        if (this.registry == null) {
            Object registryAttr = this.context.getAttribute(METRICS_REGISTRY);
            if (registryAttr instanceof MetricRegistry) {
                this.registry = (MetricRegistry)registryAttr;
            } else {
                throw new IllegalStateException(String.format(Locale.ROOT, "Couldn't find a MetricRegistry instance with key %s", METRICS_REGISTRY));
            }
        }
        TimeUnit rateUnit = this.parseTimeUnit(this.context.getInitParameter(RATE_UNIT), TimeUnit.SECONDS);
        TimeUnit durationUnit = this.parseTimeUnit(this.context.getInitParameter(DURATION_UNIT), TimeUnit.SECONDS);
        boolean showSamples = Boolean.parseBoolean(this.context.getInitParameter(SHOW_SAMPLES));
        this.mapper = new ObjectMapper().registerModule((Module)new MetricsModule(rateUnit, durationUnit, showSamples));
        this.allowedOrigin = this.context.getInitParameter(ALLOWED_ORIGIN);
        log.basicInfo(String.format(Locale.ROOT, "Successfully initialized the registry '%s'", METRICS_REGISTRY));
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    public Response doGet() {
        return this.getMetrics();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    public Response doPost() {
        return this.getMetrics();
    }

    private Response getMetrics() {
        try {
            this.response.setContentType(CONTENT_TYPE);
            if (this.allowedOrigin != null) {
                this.response.setHeader("Access-Control-Allow-Origin", this.allowedOrigin);
            }
            this.response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
            this.response.setStatus(200);
            Throwable throwable = null;
            Object var2_4 = null;
            try (ServletOutputStream output = this.response.getOutputStream();){
                this.getWriter(this.request).writeValue((OutputStream)output, (Object)this.registry);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            log.logException("metrics", ioe);
            return Response.serverError().entity((Object)String.format(Locale.ROOT, "Failed to reply correctly due to : %s ", ioe)).build();
        }
        return Response.ok().build();
    }

    private ObjectWriter getWriter(HttpServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    TimeUnit parseTimeUnit(String value, TimeUnit defaultValue) {
        try {
            return TimeUnit.valueOf(String.valueOf(value).toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

