/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.backend.hashicorp.vault;

import java.net.URI;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.knox.gateway.backend.hashicorp.vault.authentication.HashicorpVaultClientAuthenticationProvider;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AbstractAliasService;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.util.PasswordUtils;
import org.springframework.vault.VaultException;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.core.VaultVersionedKeyValueOperations;
import org.springframework.vault.support.Versioned;

public class HashicorpVaultAliasService
extends AbstractAliasService {
    public static final String TYPE = "hashicorp.vault";
    public static final String VAULT_CONFIG_PREFIX = "hashicorp.vault.";
    public static final String VAULT_ADDRESS_KEY = "hashicorp.vault.address";
    private static final String KEY = "data";
    static final String VAULT_SEPARATOR = "/";
    static final String VAULT_SECRETS_ENGINE_KEY = "hashicorp.vault.secrets.engine";
    static final String VAULT_PATH_PREFIX_KEY = "hashicorp.vault.path.prefix";
    private final AliasService localAliasService;
    private VaultVersionedKeyValueOperations vault;
    private String vaultPathPrefix;
    private GatewayConfig config;

    public HashicorpVaultAliasService(AliasService localAliasService) {
        this.localAliasService = localAliasService;
    }

    private String getPath(String clusterName) {
        return String.valueOf(this.vaultPathPrefix) + clusterName;
    }

    private String getPath(String clusterName, String alias) {
        return String.valueOf(this.getPath(clusterName)) + VAULT_SEPARATOR + alias;
    }

    public List<String> getAliasesForCluster(String clusterName) throws AliasServiceException {
        try {
            List aliases = this.vault.list(this.getPath(clusterName));
            if (aliases == null) {
                return Collections.emptyList();
            }
            Iterator iterator = aliases.iterator();
            while (iterator.hasNext()) {
                String alias = (String)iterator.next();
                if (this.getPasswordFromAliasForCluster(clusterName, alias) != null) continue;
                iterator.remove();
            }
            return aliases;
        }
        catch (VaultException e) {
            throw new AliasServiceException((Exception)((Object)e));
        }
    }

    public void addAliasForCluster(String clusterName, String alias, String value) throws AliasServiceException {
        try {
            this.vault.put(this.getPath(clusterName, alias), Collections.singletonMap(KEY, value));
        }
        catch (VaultException e) {
            throw new AliasServiceException((Exception)((Object)e));
        }
    }

    public void addAliasesForCluster(String clusterName, Map<String, String> credentials) throws AliasServiceException {
        for (Map.Entry<String, String> credential : credentials.entrySet()) {
            this.addAliasForCluster(clusterName, credential.getKey(), credential.getValue());
        }
    }

    public void removeAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        try {
            this.vault.delete(this.getPath(clusterName, alias));
        }
        catch (VaultException e) {
            throw new AliasServiceException((Exception)((Object)e));
        }
    }

    public void removeAliasesForCluster(String clusterName, Set<String> aliases) throws AliasServiceException {
        for (String alias : aliases) {
            this.removeAliasForCluster(clusterName, alias);
        }
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        try {
            Map data;
            Versioned mapVersioned = this.vault.get(this.getPath(clusterName, alias));
            if (mapVersioned != null && mapVersioned.hasData() && (data = (Map)mapVersioned.getData()) != null && data.containsKey(KEY)) {
                return String.valueOf(data.get(KEY)).toCharArray();
            }
            return null;
        }
        catch (VaultException e) {
            throw new AliasServiceException((Exception)((Object)e));
        }
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias, boolean generate) throws AliasServiceException {
        if (generate) {
            this.getPasswordFromAliasForCluster(clusterName, alias);
        }
        return this.getPasswordFromAliasForCluster(clusterName, alias);
    }

    public void generateAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        this.addAliasForCluster(clusterName, alias, PasswordUtils.generatePassword((int)16));
    }

    public char[] getPasswordFromAliasForGateway(String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster("__gateway", alias);
    }

    public char[] getGatewayIdentityPassphrase() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getIdentityKeyPassphraseAlias());
    }

    public char[] getGatewayIdentityKeystorePassword() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getIdentityKeystorePasswordAlias());
    }

    public char[] getSigningKeyPassphrase() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getSigningKeyPassphraseAlias());
    }

    public char[] getSigningKeystorePassword() throws AliasServiceException {
        return this.getPasswordFromAliasForGateway(this.config.getSigningKeystorePasswordAlias());
    }

    public void generateAliasForGateway(String alias) throws AliasServiceException {
        this.generateAliasForCluster("__gateway", alias);
    }

    public Certificate getCertificateForGateway(String alias) throws AliasServiceException {
        throw new AliasServiceException((Exception)new UnsupportedOperationException());
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        Map remoteAliasServiceConfiguration = config.getRemoteAliasServiceConfiguration();
        HashMap<String, String> vaultConfiguration = new HashMap<String, String>();
        for (Map.Entry entry : remoteAliasServiceConfiguration.entrySet()) {
            if (!((String)entry.getKey()).startsWith(VAULT_CONFIG_PREFIX)) continue;
            vaultConfiguration.put((String)entry.getKey(), (String)entry.getValue());
        }
        String vaultAddress = (String)vaultConfiguration.get(VAULT_ADDRESS_KEY);
        String vaultSecretsEngine = (String)vaultConfiguration.get(VAULT_SECRETS_ENGINE_KEY);
        this.vaultPathPrefix = this.getVaultPathPrefix(vaultConfiguration);
        try {
            VaultEndpoint vaultEndpoint = VaultEndpoint.from((URI)new URI(vaultAddress));
            ClientAuthentication vaultAuthentication = this.getClientAuthentication(vaultConfiguration);
            VaultTemplate vaultTemplate = new VaultTemplate(vaultEndpoint, vaultAuthentication);
            this.vault = vaultTemplate.opsForVersionedKeyValue(vaultSecretsEngine);
        }
        catch (Exception e) {
            throw new ServiceLifecycleException("Failed to init", e);
        }
    }

    private String getVaultPathPrefix(Map<String, String> properties) {
        String vaultPathPrefix = properties.get(VAULT_PATH_PREFIX_KEY);
        if (vaultPathPrefix == null) {
            return "";
        }
        if (vaultPathPrefix.startsWith(VAULT_SEPARATOR)) {
            vaultPathPrefix = vaultPathPrefix.replaceFirst(VAULT_SEPARATOR, "");
        }
        if (vaultPathPrefix.endsWith(VAULT_SEPARATOR)) {
            return vaultPathPrefix;
        }
        return String.valueOf(vaultPathPrefix) + VAULT_SEPARATOR;
    }

    private ClientAuthentication getClientAuthentication(Map<String, String> properties) throws Exception {
        String authenticationType = properties.get("hashicorp.vault.authentication.type");
        ServiceLoader<HashicorpVaultClientAuthenticationProvider> providers = ServiceLoader.load(HashicorpVaultClientAuthenticationProvider.class);
        for (HashicorpVaultClientAuthenticationProvider provider : providers) {
            if (!authenticationType.equals(provider.getType())) continue;
            return provider.newInstance(this.localAliasService, properties);
        }
        throw new IllegalStateException("Not able to find client authentication provider");
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }
}

