/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.tools;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.knox.gateway.cloud.idbroker.tools.BrokerEntryPoint;

public class GetObjectHeaders
extends BrokerEntryPoint {
    public static final String USAGE = "Usage: GetObjectHeaders [-req header=value] <file>";
    public static final String REQUIRE = "req";
    public static final String PREFIX = "header.";

    public GetObjectHeaders() {
        this.setCommandFormat(new CommandFormat(1, 1, new String[0]));
        this.getCommandFormat().addOptionWithValue(REQUIRE);
    }

    public int run(String[] args, PrintStream stream) throws Exception {
        this.setOut(stream);
        List<String> paths = this.parseArgs(args);
        if (paths.size() != 1) {
            GetObjectHeaders.errorln(USAGE, new Object[0]);
            return 42;
        }
        Configuration conf = new Configuration();
        Path source = new Path(paths.get(0));
        FileSystem fs = source.getFileSystem(conf);
        try {
            Map xAttrs = fs.getXAttrs(source);
            HashMap headers = new HashMap(xAttrs.size());
            xAttrs.forEach((k, bytes) -> {
                String key = k;
                String v2 = new String((byte[])bytes, StandardCharsets.UTF_8);
                if (key.startsWith(PREFIX)) {
                    key = key.substring(PREFIX.length());
                }
                headers.put(key, v2);
            });
            for (Map.Entry entry : headers.entrySet()) {
                this.println("%s: \"%s\"", entry.getKey(), entry.getValue());
            }
            this.getOptional(REQUIRE).ifPresent(required -> this.verifyHeaderIsPresent((String)required, headers));
        }
        catch (FileNotFoundException e) {
            throw new ExitUtil.ExitException(44, source.toString(), (Throwable)e);
        }
        return 0;
    }

    private void verifyHeaderIsPresent(String required, Map<String, String> headers) {
        int split = required.indexOf(61);
        int len = required.length();
        if (split == 0 || split + 1 == len) {
            throw new ExitUtil.ExitException(42, "Failed to parse required option of " + required);
        }
        String header = split > 0 ? required.substring(0, split) : required;
        String expected = split > 0 ? required.substring(split + 1, len) : null;
        String headerVal = headers.get(header);
        if (headerVal == null) {
            throw new ExitUtil.ExitException(46, "No header " + header);
        }
        String actual = headerVal;
        if (expected != null && !expected.equals(actual)) {
            throw new ExitUtil.ExitException(46, "Value of header " + header + " must be \"" + expected + "\" but is \"" + actual + "\"");
        }
        this.println("Verified value of %s is %s", header, actual);
    }

    @Override
    public final int run(String[] args) throws Exception {
        return this.run(args, System.out);
    }

    public static int exec(String ... args) throws Exception {
        return ToolRunner.run((Tool)new GetObjectHeaders(), (String[])args);
    }

    public static void main(String[] args) {
        try {
            GetObjectHeaders.exit(GetObjectHeaders.exec(args), "");
        }
        catch (Throwable e) {
            GetObjectHeaders.exitOnThrowable(e);
        }
    }
}

