/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Tool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerEntryPoint
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerEntryPoint.class);
    private PrintStream out = System.out;
    private CommandFormat commandFormat;

    protected static void errorln(String format, Object ... args) {
        System.err.println(String.format(Locale.ROOT, format, args));
        System.err.flush();
    }

    protected static void exit(int status, String text) {
        ExitUtil.terminate((int)status, (String)text);
    }

    protected static void exit(ExitUtil.ExitException ex) {
        ExitUtil.terminate((ExitUtil.ExitException)ex);
    }

    public int run(String[] args) throws Exception {
        return 0;
    }

    public PrintStream getOut() {
        return this.out;
    }

    public void setOut(PrintStream out) {
        this.out = out;
    }

    protected void println(String format, Object ... args) {
        this.out.println(String.format(Locale.ROOT, format, args));
        this.out.flush();
    }

    protected void heading(String format, Object ... args) {
        String text = String.format(Locale.ROOT, format, args);
        int l = text.length();
        StringBuilder sb = new StringBuilder(l);
        for (int i = 0; i < l; ++i) {
            sb.append('=');
        }
        this.println("\n%s\n%s\n", text, sb.toString());
    }

    public CommandFormat getCommandFormat() {
        return this.commandFormat;
    }

    public void setCommandFormat(CommandFormat commandFormat) {
        this.commandFormat = commandFormat;
    }

    protected List<String> parseArgs(String[] args) {
        return args.length > 0 ? this.getCommandFormat().parse(args, 0) : new ArrayList(0);
    }

    protected String getOption(String opt) {
        return this.getCommandFormat().getOptValue(opt);
    }

    protected Optional<String> getOptional(String opt) {
        return Optional.ofNullable(this.getCommandFormat().getOptValue(opt));
    }

    protected boolean hasOption(String opt) {
        return this.getCommandFormat().getOpt(opt);
    }

    protected void addAllDefaultXMLFiles() {
        Configuration.addDefaultResource((String)"hdfs-default.xml");
        Configuration.addDefaultResource((String)"hdfs-site.xml");
        Configuration.addDefaultResource((String)"mapred-default.xml");
        Configuration.addDefaultResource((String)"mapred-site.xml");
        Configuration.addDefaultResource((String)"yarn-default.xml");
        Configuration.addDefaultResource((String)"yarn-site.xml");
    }

    protected static void exitOnThrowable(Throwable ex) {
        if (ex instanceof CommandFormat.UnknownOptionException) {
            BrokerEntryPoint.errorln(ex.getMessage(), new Object[0]);
            BrokerEntryPoint.exit(42, ex.getMessage());
        } else if (ex instanceof ExitUtil.ExitException) {
            LOG.debug("Command failure", ex);
            BrokerEntryPoint.exit((ExitUtil.ExitException)ex);
        } else {
            ex.printStackTrace(System.err);
            BrokerEntryPoint.exit(-1, ex.toString());
        }
    }

    protected void maybeAddXMLFileOption(Configuration conf, String opt) throws FileNotFoundException, MalformedURLException {
        String xmlfile = this.getOption(opt);
        if (xmlfile != null) {
            File f = new File(xmlfile);
            if (!f.exists()) {
                throw new FileNotFoundException(f.toString());
            }
            this.println("Adding XML configuration file %s", f);
            conf.addResource(f.toURI().toURL());
        }
    }
}

