/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.s3a;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentialBinding;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.NoAuthWithAWSException;
import org.apache.hadoop.fs.s3a.auth.RoleModel;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractDelegationTokenBinding;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.fs.s3a.auth.delegation.DelegationTokenIOException;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxTokenMonitor;
import org.apache.knox.gateway.cloud.idbroker.common.UTCClock;
import org.apache.knox.gateway.cloud.idbroker.messages.RequestDTResponseMessage;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBS3AConstants;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBS3ATokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBClient;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBProperty;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.util.Tokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class IDBDelegationTokenBinding
extends AbstractDelegationTokenBinding {
    private static final String E_NO_ACQUIRE_TOKEN_FROM_TOKEN = "Cannot acquire Knox token unless logged in; using %s";
    private static final String E_NO_ACQUIRE_TOKEN_WHEN_HAS_EXPIRED = "Knox token has expired; the current token is %s";
    private static final String E_NO_KNOX_DELEGATION_TOKEN = "No Knox token";
    private static final String E_NO_SESSION_TO_KNOX_AWS = "No session to knox AWS credential endpoint";
    protected static final Logger LOG = LoggerFactory.getLogger(IDBDelegationTokenBinding.class);
    private static final String NAME = "IDBDelegationToken";
    private static final String COMPONENT_NAME = "IDBDelegationToken";
    private AWSCredentialProviderList credentialProviders;
    private MarshalledCredentials marshalledCredentials;
    private S3AIDBClient idbClient;
    private UTCClock clock = UTCClock.getClock();
    private IDBS3ATokenIdentifier boundTokenIdentifier;
    private boolean collectAwsCredentials = true;
    private KnoxToken knoxToken;
    private KnoxTokenMonitor knoxTokenMonitor;
    private final Lock lock = new ReentrantLock(true);

    public IDBDelegationTokenBinding() {
        this("IDBDelegationToken", IDBS3AConstants.IDB_TOKEN_KIND);
    }

    public IDBDelegationTokenBinding(String name, Text kind) {
        super(name, kind);
    }

    private void initKnoxTokenMonitor() {
        if (this.knoxTokenMonitor == null && this.idbClient != null && this.idbClient.shouldInitKnoxTokenMonitor()) {
            this.knoxTokenMonitor = new KnoxTokenMonitor();
        }
    }

    @VisibleForTesting
    protected MarshalledCredentials fetchMarshalledAWSCredentials(S3AIDBClient client, CloudAccessBrokerSession credentialSession) throws IOException {
        return (MarshalledCredentials)client.fetchCloudCredentials(credentialSession);
    }

    private void bondToRequestedToken(RequestDTResponseMessage response) throws IOException {
        String token = this.extractTokenFromResponse(response);
        LOG.info("Bonded to Knox token {}", (Object)Tokens.getTokenDisplayText((String)token));
        String gatewayCertificate = this.extractGatewayCertificate(response);
        if (gatewayCertificate.isEmpty()) {
            LOG.warn("No certificate provided by gateway: renewals will not work");
        }
        this.updateAndMonitorKnoxToken(new KnoxToken("", token, response.token_type, response.expiryTimeSeconds(), gatewayCertificate, response.managed));
    }

    private String extractGatewayCertificate(RequestDTResponseMessage response) {
        String cert = response.endpoint_public_cert;
        if (cert == null) {
            cert = "";
        }
        return cert;
    }

    private String extractTokenFromResponse(RequestDTResponseMessage response) throws DelegationTokenIOException {
        String token = response.access_token;
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new DelegationTokenIOException(E_NO_KNOX_DELEGATION_TOKEN);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractS3ATokenIdentifier createTokenIdentifier(Optional<RoleModel.Policy> policy, EncryptionSecrets encryptionSecrets, Text renewer) throws IOException {
        this.lock.lock();
        try {
            this.credentialProviders = new AWSCredentialProviderList();
            this.credentialProviders.add((AwsCredentialsProvider)new IDBCredentials());
            this.maybeRenewAccessToken("creating token identifier");
            String knoxDT = this.knoxToken == null ? "" : this.knoxToken.getAccessToken();
            long expiryTime = this.knoxToken == null ? 0L : this.knoxToken.getExpiry();
            String endpointCertificate = this.knoxToken == null ? "" : this.knoxToken.getEndpointPublicCert();
            boolean managed = this.knoxToken == null ? false : this.knoxToken.isManaged();
            String endpoint = this.idbClient.getCredentialsURL();
            IDBS3ATokenIdentifier identifier = new IDBS3ATokenIdentifier(IDBS3AConstants.IDB_TOKEN_KIND, this.getOwnerText(), renewer, this.getCanonicalUri(), knoxDT, expiryTime, this.collectAWSCredentialsForDelegation(), encryptionSecrets, Objects.toString(policy.orElse(null), ""), "Created from " + endpoint, System.currentTimeMillis(), this.getOwner().getUserName(), endpoint, endpointCertificate, managed);
            LOG.info("Created token identifier {}", (Object)identifier);
            IDBS3ATokenIdentifier iDBS3ATokenIdentifier = identifier;
            return iDBS3ATokenIdentifier;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AWSCredentialProviderList deployUnbonded() throws IOException {
        this.lock.lock();
        try {
            this.idbClient = S3AIDBClient.createFullIDBClient(this.getConfig(), this.getOwner(), this.getFileSystem());
            Configuration conf = this.getConfig();
            this.credentialProviders = new AWSCredentialProviderList();
            this.credentialProviders.add((AwsCredentialsProvider)new IDBCredentials());
            this.collectAwsCredentials = conf.getBoolean(S3AIDBProperty.IDBROKER_INIT_CAB_CREDENTIALS.getPropertyName(), Boolean.valueOf(S3AIDBProperty.IDBROKER_INIT_CAB_CREDENTIALS.getDefaultValue()).booleanValue());
            this.maybeRenewAccessToken("deploying unbonded token");
            AWSCredentialProviderList aWSCredentialProviderList = this.credentialProviders;
            return aWSCredentialProviderList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier retrievedIdentifier) throws IOException {
        this.lock.lock();
        try {
            LOG.info("Binding to retrieved Delegation Token identifier: " + retrievedIdentifier == null ? "N/A" : retrievedIdentifier.toString());
            this.idbClient = S3AIDBClient.createLightIDBClient(this.getConfig(), this.getFileSystem());
            IDBS3ATokenIdentifier tokenIdentifier = (IDBS3ATokenIdentifier)this.convertTokenIdentifier(retrievedIdentifier, IDBS3ATokenIdentifier.class);
            tokenIdentifier.validate();
            this.boundTokenIdentifier = tokenIdentifier;
            this.marshalledCredentials = IDBDelegationTokenBinding.extractMarshalledCredentials(tokenIdentifier);
            this.updateAndMonitorKnoxToken(new KnoxToken(tokenIdentifier.getOrigin(), tokenIdentifier.getAccessToken(), tokenIdentifier.getExpiryTime(), tokenIdentifier.getCertificate(), tokenIdentifier.isManaged()));
            if (StringUtils.isNotEmpty((CharSequence)this.knoxToken.getEndpointPublicCert())) {
                LOG.debug("Using Cloud Access Broker public cert from delegation token");
            }
            this.credentialProviders = new AWSCredentialProviderList();
            this.credentialProviders.add((AwsCredentialsProvider)new IDBCredentials());
            LOG.debug("Renewing AWS Credentials if needed");
            if (this.maybeResetAWSCredentials().booleanValue()) {
                LOG.info("New AWS credentials will be requested");
            }
            AWSCredentialProviderList aWSCredentialProviderList = this.credentialProviders;
            return aWSCredentialProviderList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public IDBS3ATokenIdentifier createEmptyIdentifier() {
        return new IDBS3ATokenIdentifier();
    }

    public String toString() {
        this.lock.lock();
        try {
            String string = "IDBDelegationTokenBinding{marshaledCredentials=" + Objects.toString(this.marshalledCredentials, "<unset>") + ", accessToken=" + Objects.toString(this.knoxToken, "<unset>") + '}';
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestDTResponseMessage requestNewKnoxToken(boolean hasExpired) throws IOException {
        RequestDTResponseMessage requestDTResponseMessage;
        Pair<KnoxSession, String> sessionPair = this.getNewKnoxDelegationTokenSession();
        KnoxSession session = (KnoxSession)sessionPair.getLeft();
        if (session == null) {
            String tokenInfo = this.boundTokenIdentifier == null ? "" : this.boundTokenIdentifier.errorMessageString();
            String message = hasExpired ? String.format(Locale.ROOT, E_NO_ACQUIRE_TOKEN_WHEN_HAS_EXPIRED, tokenInfo) : String.format(Locale.ROOT, E_NO_ACQUIRE_TOKEN_FROM_TOKEN, tokenInfo);
            throw new DelegationTokenIOException(message);
        }
        String origin = (String)sessionPair.getRight();
        try {
            requestDTResponseMessage = this.idbClient.requestKnoxDelegationToken(session, origin, this.getCanonicalUri());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{session});
        return requestDTResponseMessage;
    }

    private Pair<KnoxSession, String> getNewKnoxDelegationTokenSession() throws IOException {
        LOG.debug("Attempting to create a Knox delegation token session using local credentials (kerberos, simple)");
        Pair<KnoxSession, String> sessionDetails = this.idbClient.createKnoxDTSession(this.getConfig());
        if (sessionDetails.getLeft() != null) {
            LOG.debug("Created a Knox delegation token session using local credentials (kerberos, simple)");
        }
        if (sessionDetails.getLeft() == null) {
            String message = this.knoxToken == null ? "Authentication with IDBroker failed.  Please ensure you have a Kerberos token by using kinit." : "Authentication with IDBroker failed.  The existing Knox delegation token has expired and must be renewed. However, it cannot be renewed unless a valid Kerberos token is available. Please ensure you have a Kerberos token by using kinit.";
            throw new IllegalStateException(message);
        }
        return sessionDetails;
    }

    private void maybeRenewAccessToken(String source) throws IOException {
        LOG.debug("Maybe renewing Knox Token when {}", (Object)source);
        if (this.knoxToken == null || StringUtils.isBlank((CharSequence)this.knoxToken.getAccessToken())) {
            if (this.idbClient.shouldExcludeUserFromGettingKnoxToken()) {
                LOG.info("'{}' is excluded from getting Knox Token from IDBroker", (Object)this.idbClient.getOwnerUserName());
            } else {
                LOG.info("There is no Knox Token available, fetching one from IDBroker...");
                this.getNewKnoxToken(true);
            }
        } else {
            LOG.debug("Using existing Knox Token: " + Tokens.getTokenDisplayText((String)this.knoxToken.getAccessToken()));
            this.maybeReplaceExpiredKnoxTokenFromUGI();
            this.enforceKnoxTokenNotExpired();
        }
    }

    private void enforceKnoxTokenNotExpired() throws IOException {
        long knoxTokenExpirationOffset;
        if (this.knoxTokenMonitor == null && this.knoxToken.isAboutToExpire(knoxTokenExpirationOffset = this.getConfig().getLong(S3AIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getPropertyName(), Long.parseLong(S3AIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getDefaultValue()))) && this.idbClient.hasKerberosCredentials()) {
            this.getNewKnoxToken(true);
        }
    }

    private void getNewKnoxToken(boolean hasExpired) throws IOException {
        RequestDTResponseMessage message = this.requestNewKnoxToken(!hasExpired);
        if (message != null) {
            this.bondToRequestedToken(message);
        }
    }

    private MarshalledCredentials collectAWSCredentialsForDelegation() throws IOException {
        return this.collectAwsCredentials ? this.collectAWSCredentials() : MarshalledCredentials.empty();
    }

    private MarshalledCredentials collectAWSCredentials() throws IOException {
        if (this.maybeResetAWSCredentials().booleanValue()) {
            this.updateAWSCredentials();
        }
        LOG.debug("AWS credentials: {}", (Object)this.marshalledCredentials.toString());
        return this.marshalledCredentials;
    }

    @VisibleForTesting
    void updateAWSCredentials() throws IOException {
        LOG.debug("Requesting AWS credentials from IDBroker");
        CloudAccessBrokerSession knoxCABSession = this.idbClient.createKnoxCABSession(this.knoxToken);
        if (knoxCABSession == null) {
            throw new DelegationTokenIOException(E_NO_SESSION_TO_KNOX_AWS);
        }
        this.marshalledCredentials = this.fetchMarshalledAWSCredentials(this.idbClient, knoxCABSession);
    }

    private void maybeReplaceExpiredKnoxTokenFromUGI() throws IOException {
        if (this.knoxToken.isExpired()) {
            URI fsUri = this.getFileSystem().getUri();
            Text serviceName = new Text(fsUri.getScheme() + "://" + fsUri.getAuthority());
            IDBS3ATokenIdentifier token = IDBS3ATokenIdentifier.fromUGI(this.getOwner(), serviceName);
            if (token != null) {
                this.updateAndMonitorKnoxToken(new KnoxToken(token.getOrigin(), token.getAccessToken(), token.getExpiryTime(), token.getCertificate(), token.isManaged()));
                LOG.info("Updated knoxToken from UGI to {}", (Object)Tokens.getTokenDisplayText((String)this.knoxToken.getAccessToken()));
            } else {
                LOG.warn("Token {} expired but no new token was found in UGI", (Object)Tokens.getTokenDisplayText((String)this.knoxToken.getAccessToken()));
            }
        }
    }

    private void updateAndMonitorKnoxToken(KnoxToken newKnoxToken) {
        this.knoxToken = newKnoxToken;
        this.monitorKnoxToken();
    }

    @VisibleForTesting
    Boolean maybeResetAWSCredentials() {
        if (this.areAWSCredentialsNeeded()) {
            this.resetAWSCredentials();
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean areAWSCredentialsNeeded() {
        LOG.debug("Checking if AWS credentials are needed");
        LOG.debug("Clock current time: {}", (Object)this.clock.getCurrentTime());
        if (this.marshalledCredentials == null) {
            return true;
        }
        long credentialsExpirationOffset = this.getConfig().getLong(S3AIDBProperty.IDBROKER_CAB_CREDENTIALS_EXPIRATION_OFFSET.getPropertyName(), Long.parseLong(S3AIDBProperty.IDBROKER_CAB_CREDENTIALS_EXPIRATION_OFFSET.getDefaultValue()));
        Optional<OffsetDateTime> expirationDateTime = this.marshalledCredentials.getExpirationDateTime();
        expirationDateTime = expirationDateTime.map(dateTime -> dateTime.minusSeconds(credentialsExpirationOffset));
        LOG.debug("Credential expiration time with {} seconds offset: {}", (Object)credentialsExpirationOffset, expirationDateTime);
        return this.clock.hasExpired(expirationDateTime);
    }

    @VisibleForTesting
    void resetAWSCredentials() {
        LOG.debug("Resetting AWS credentials");
        this.marshalledCredentials = null;
    }

    @VisibleForTesting
    static MarshalledCredentials extractMarshalledCredentials(IDBS3ATokenIdentifier tokenIdentifier) {
        MarshalledCredentials incomingAwsCreds = tokenIdentifier.getMarshalledCredentials();
        return incomingAwsCreds.isValid(MarshalledCredentials.CredentialTypeRequired.SessionOnly) ? incomingAwsCreds : null;
    }

    protected void serviceStop() throws Exception {
        this.stopKnoxTokenMonitor();
        super.serviceStop();
    }

    private void monitorKnoxToken() {
        this.initKnoxTokenMonitor();
        if (this.knoxTokenMonitor != null) {
            long knoxTokenExpirationOffset = this.getConfig().getLong(S3AIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getPropertyName(), Long.parseLong(S3AIDBProperty.IDBROKER_DT_EXPIRATION_OFFSET.getDefaultValue()));
            this.knoxTokenMonitor.monitorKnoxToken(this.knoxToken, knoxTokenExpirationOffset, new GetKnoxTokenCommand());
        }
    }

    private void stopKnoxTokenMonitor() {
        if (this.knoxTokenMonitor != null) {
            this.knoxTokenMonitor.shutdown();
        }
    }

    private class GetKnoxTokenCommand
    implements KnoxTokenMonitor.GetKnoxTokenCommand {
        private GetKnoxTokenCommand() {
        }

        @Override
        public void execute(KnoxToken knoxToken) throws IOException {
            IDBDelegationTokenBinding.this.lock.lock();
            try {
                IDBDelegationTokenBinding.this.getNewKnoxToken(knoxToken != null);
            }
            finally {
                IDBDelegationTokenBinding.this.lock.unlock();
            }
        }
    }

    private class IDBCredentials
    implements AwsCredentialsProvider {
        private IDBCredentials() {
        }

        public AwsCredentials resolveCredentials() {
            try {
                return this.fetchCredentials();
            }
            catch (IOException e) {
                LOG.warn("Failed to fetch credentials: " + e.getMessage());
                LOG.debug("Failed to fetch credentials: ", (Throwable)e);
                throw new NoAuthWithAWSException(e.getMessage(), (Throwable)e);
            }
        }

        private AwsCredentials fetchCredentials() throws IOException {
            IDBDelegationTokenBinding.this.lock.lock();
            try {
                IDBDelegationTokenBinding.this.maybeRenewAccessToken("fetching AWS credentials");
                AwsCredentials awsCredentials = MarshalledCredentialBinding.toAWSCredentials((MarshalledCredentials)IDBDelegationTokenBinding.this.collectAWSCredentials(), (MarshalledCredentials.CredentialTypeRequired)MarshalledCredentials.CredentialTypeRequired.SessionOnly, (String)"IDBDelegationToken");
                return awsCredentials;
            }
            finally {
                IDBDelegationTokenBinding.this.lock.unlock();
            }
        }

        public String toString() {
            return "IDBCredentials for " + IDBDelegationTokenBinding.super.toString();
        }
    }
}

