/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.messages;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.cloud.idbroker.messages.ValidationFailure;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonSerialize
public class RequestDTResponseMessage {
    public static final String BEARER_TOKEN = "Bearer";
    public String access_token;
    public String token_type;
    public String target_url;
    public BigInteger expires_in;
    public String endpoint_public_cert;
    public String managed;

    public RequestDTResponseMessage validate() throws IOException {
        ValidationFailure.verify(StringUtils.isNotEmpty((CharSequence)this.access_token), "Empty Access Token", new Object[0]);
        ValidationFailure.verify(BEARER_TOKEN.equals(this.token_type), "Token type isn't %s: %s", BEARER_TOKEN, this.token_type);
        return this;
    }

    public long expiryTimeSeconds() {
        return this.expires_in != null ? TimeUnit.MILLISECONDS.toSeconds(this.expires_in.longValue()) : 0L;
    }
}

