/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.apache.knox.gateway.cloud.idbroker.google.DateTime;
import org.apache.knox.gateway.cloud.idbroker.google.TokenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAccessTokenProvider
implements TokenProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestAccessTokenProvider.class);
    private final AccessTokenProvider provider;
    private boolean getTestToken;
    private Path testTokenPath;

    TestAccessTokenProvider(AccessTokenProvider provider) {
        LOG.warn("This implementation of the AccessTokenProvider is for testing purposes only");
        this.provider = provider;
    }

    @Override
    public void updateDelegationToken(KnoxToken token) {
    }

    public AccessTokenProvider.AccessToken getAccessToken() {
        AccessTokenProvider.AccessToken token;
        if (this.getTestToken) {
            try {
                token = this.readTestToken();
            }
            catch (IOException e) {
                LOG.error("This implementation of the AccessTokenProvider is for testing purposes only - failed to use a TEST access token", (Throwable)e);
                token = null;
            }
            this.getTestToken = false;
        } else {
            token = null;
        }
        if (token == null) {
            LOG.warn("This implementation of the AccessTokenProvider is for testing purposes only - using REAL access token");
            return this.provider.getAccessToken();
        }
        LOG.warn("This implementation of the AccessTokenProvider is for testing purposes only - using TEST access token");
        return token;
    }

    public void refresh() throws IOException {
        this.getTestToken = this.testTokenPath != null;
        this.provider.refresh();
    }

    public void setConf(Configuration configuration) {
        String propertyValue = configuration.getTrimmed("fs.gs.ext.cab.test.token.path");
        if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
            Path path = Paths.get(propertyValue, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.warn("The specified path does not exist, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isRegularFile(path, new LinkOption[0])) {
                LOG.warn("The specified path is not a file, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isReadable(path)) {
                LOG.warn("The specified file is not readable, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else {
                this.testTokenPath = path;
                LOG.warn("Using test access token from {}", (Object)this.testTokenPath.toAbsolutePath());
            }
        } else {
            LOG.warn("A file for a test token was not specified, a test token will not be used");
            this.testTokenPath = null;
        }
        this.getTestToken = this.testTokenPath != null;
        this.provider.setConf(configuration);
    }

    public Configuration getConf() {
        return this.provider.getConf();
    }

    private AccessTokenProvider.AccessToken readTestToken() throws IOException {
        Map map;
        if (this.testTokenPath != null) {
            try (InputStream inputStream = Files.newInputStream(this.testTokenPath, new OpenOption[0]);){
                ObjectMapper om = new ObjectMapper();
                map = (Map)om.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
        } else {
            map = null;
        }
        if (map != null) {
            String accessToken = (String)map.get("accessToken");
            String expireTime = (String)map.get("expireTime");
            long expirationDateTime = DateTime.parseRfc3339(expireTime).getValue();
            return new AccessTokenProvider.AccessToken(accessToken, Long.valueOf(expirationDateTime));
        }
        return null;
    }
}

