/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.knox.gateway.cloud.idbroker.IDBClient;
import org.apache.knox.gateway.cloud.idbroker.common.CommonUtils;
import org.apache.knox.gateway.cloud.idbroker.common.Preconditions;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CABUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CABUtils.class);

    private CABUtils() {
    }

    static IDBClient<AccessTokenProvider.AccessToken> newClient(Configuration conf, UserGroupInformation owner) {
        IDBClient<AccessTokenProvider.AccessToken> client = null;
        LOG.info("Creating new GCP IDBroker client.");
        String clientImpl = conf.get("fs.gs.ext.cab.client.impl");
        if (clientImpl != null) {
            try {
                Class<?> clazz = Class.forName(clientImpl, false, Thread.currentThread().getContextClassLoader());
                Constructor<?> ctor = clazz.getConstructor(Configuration.class);
                Object instance = ctor.newInstance(conf);
                if (!IDBClient.class.isAssignableFrom(instance.getClass())) {
                    throw new IllegalArgumentException(clientImpl + " is not a IDBClient<AccessTokenProvider.AccessToken> implementation.");
                }
                client = (IDBClient)instance;
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                LOG.error("Failed to instantiate the configured IDBClient implementation {} : {}", (Object)clientImpl, (Object)t);
            }
        }
        if (client == null) {
            LOG.debug("Using the default CloudAccessBrokerClient");
            try {
                client = new GoogleIDBClient(conf, owner);
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
                LOG.error("Failed to instantiate the default IDBClient implementation {} : {}", (Object)clientImpl, (Object)t);
            }
        }
        if (client == null) {
            LOG.error("GCP IDBroker client was not instantiated.");
        }
        return client;
    }

    static void setCloudAccessBrokerAddresses(Configuration conf, String ... endpoints) {
        String endpointDelimiter = ",";
        String endpointConfigValue = "";
        for (int i = 0; i < endpoints.length; ++i) {
            endpointConfigValue = endpointConfigValue + endpoints[i];
            if (i >= endpoints.length - 1) continue;
            endpointConfigValue = endpointConfigValue + ",";
        }
        conf.set("fs.gs.ext.cab.address", endpointConfigValue);
    }

    static List<String> getCloudAccessBrokerAddresses(Configuration conf) throws IllegalArgumentException {
        ArrayList<String> addresses = new ArrayList<String>();
        String[] configuredValues = conf.getStrings("fs.gs.ext.cab.address");
        Preconditions.checkArgument(configuredValues.length == 0, "No URL(s) provided in %s", "fs.gs.ext.cab.address");
        for (String address : configuredValues) {
            addresses.add(address.trim());
        }
        return addresses;
    }

    static String getCloudAccessBrokerURL(Configuration conf, String endpoint) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)endpoint), "Invalid endpoint address.");
        return CABUtils.getBrokerURL(conf, endpoint, "fs.gs.ext.cab.path", "gcp-cab");
    }

    static String getDelegationTokenProviderURL(Configuration conf, String endpoint) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)endpoint), "Invalid endpoint address.");
        return CABUtils.getBrokerURL(conf, endpoint, "fs.gs.ext.cab.dt.path", "dt");
    }

    static String getBrokerURL(Configuration conf, String baseEndpoint, String key, String defVal) {
        String v = conf.getTrimmed(key, defVal);
        Preconditions.checkArgument(!v.isEmpty(), "No path in %s", key);
        return CABUtils.constructURL(baseEndpoint, v);
    }

    public static String constructURL(String address, String path) {
        String url = null;
        if (StringUtils.isNotEmpty((CharSequence)address) && StringUtils.isNotEmpty((CharSequence)path)) {
            String a = address;
            if (a.endsWith("/")) {
                a = a.substring(0, a.length() - 1);
            }
            url = a + (!path.startsWith("/") ? "/" : "") + path;
        }
        return url;
    }

    static String getTrustStoreLocation(Configuration conf) {
        CABUtils.validateConf(conf);
        return CommonUtils.getTruststoreLocation(conf, "fs.gs.ext.cab.truststore.location");
    }

    static String getTrustStorePass(Configuration conf) {
        CABUtils.validateConf(conf);
        return CommonUtils.getTruststorePass(conf, "fs.gs.ext.cab.truststore.pass");
    }

    static String getTrustStoreType(Configuration conf) {
        CABUtils.validateConf(conf);
        return CommonUtils.getTruststorePass(conf, "fs.gs.ext.cab.truststore.type");
    }

    static String getConfigSecret(Configuration conf, String name, String envVar) {
        CABUtils.validateConf(conf);
        String value = CABUtils.getAlias(conf, name);
        if (StringUtils.isEmpty((CharSequence)value) && StringUtils.isNotEmpty((CharSequence)envVar)) {
            value = System.getenv(envVar);
        }
        return value;
    }

    static String getRequiredConfigSecret(Configuration conf, String name, String envVar, String errorText) {
        CABUtils.validateConf(conf);
        String value = CABUtils.getConfigSecret(conf, name, envVar);
        if (StringUtils.isEmpty((CharSequence)value)) {
            LOG.error(errorText);
            throw new IllegalStateException(errorText);
        }
        return value;
    }

    private static String getAlias(Configuration conf, String alias) {
        return CommonUtils.getPassword(conf, alias);
    }

    private static void validateConf(Configuration conf) {
        if (conf == null) {
            LOG.info("No configuration has been provided.");
            throw new IllegalStateException("No configuration has been provided.");
        }
    }
}

