/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.google;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.http.client.config.RequestConfig;
import org.apache.knox.gateway.cloud.idbroker.common.AbstractIDBTokenRenewer;
import org.apache.knox.gateway.cloud.idbroker.common.RequestErrorHandlingAttributes;
import org.apache.knox.gateway.cloud.idbroker.google.CABGCPTokenIdentifier;
import org.apache.knox.gateway.cloud.idbroker.google.CloudAccessBrokerBindingConstants;
import org.apache.knox.gateway.cloud.idbroker.google.GoogleIDBProperty;

public class CABGCPTokenRenewer
extends AbstractIDBTokenRenewer {
    private static final String GATEWAY_ADDRESS_PROPERTY = GoogleIDBProperty.IDBROKER_GATEWAY.getPropertyName();
    private static final String DT_PATH_PROPERTY = GoogleIDBProperty.IDBROKER_DT_PATH.getPropertyName();

    public boolean handleKind(Text text) {
        return CloudAccessBrokerBindingConstants.CAB_TOKEN_KIND.equals((Object)text);
    }

    @Override
    protected String getAccessToken(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).getAccessToken();
    }

    @Override
    protected long getTokenExpiration(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).getExpiryTime();
    }

    @Override
    protected List<String> getGatewayAddressConfigProperty(Configuration config) {
        return Arrays.asList(config.getStrings(GATEWAY_ADDRESS_PROPERTY));
    }

    @Override
    protected String getDelegationTokenPathConfigProperty(Configuration config) {
        return config.get(DT_PATH_PROPERTY);
    }

    @Override
    protected RequestErrorHandlingAttributes getRequestErrorHandlingAttributes(Configuration configuration) {
        return new RequestErrorHandlingAttributes(this.getIntValue(configuration, GoogleIDBProperty.IDBROKER_MAX_FAILOVER_ATTEMPTS), this.getIntValue(configuration, GoogleIDBProperty.IDBROKER_FAILOVER_SLEEP), this.getIntValue(configuration, GoogleIDBProperty.IDBROKER_MAX_RETRY_ATTEMPTS), this.getIntValue(configuration, GoogleIDBProperty.IDBROKER_RETRY_SLEEP));
    }

    @Override
    protected boolean isManagedToken(DelegationTokenIdentifier identifier) {
        return ((CABGCPTokenIdentifier)identifier).isManaged();
    }

    @Override
    protected RequestConfig getHttpRequestConfiguration(Configuration configuration) {
        return RequestConfig.custom().setConnectionRequestTimeout(this.getIntValue(configuration, GoogleIDBProperty.IDBROKER_HTTP_CONNECTION_REQ_TIMEOUT)).setConnectTimeout(this.getIntValue(configuration, GoogleIDBProperty.IDBROKER_HTTP_CONNECTION_TIMEOUT)).setSocketTimeout(this.getIntValue(configuration, GoogleIDBProperty.IDBROKER_HTTP_SOCKET_TIMEOUT)).build();
    }
}

