/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

public class UTCClock {
    public static final String NO_DATE_TIME = "none";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final UTCClock clock = new UTCClock();

    private UTCClock() {
    }

    public static UTCClock getClock() {
        return clock;
    }

    public long getCurrentTimeInMillis() {
        return Calendar.getInstance(UTC, Locale.getDefault(Locale.Category.FORMAT)).getTimeInMillis();
    }

    public OffsetDateTime getCurrentTime() {
        return UTCClock.millisToDateTime(this.getCurrentTimeInMillis()).get();
    }

    public boolean hasExpired(OffsetDateTime dateTime) {
        return dateTime.compareTo(this.getCurrentTime()) < 0;
    }

    public boolean hasExpired(Optional<OffsetDateTime> dateTime) {
        return dateTime.map(this::hasExpired).orElse(true);
    }

    public static String secondsToString(long timeInSeconds) {
        return UTCClock.timeToString(UTCClock.secondsToDateTime(timeInSeconds));
    }

    public static String timeToString(Optional<OffsetDateTime> dateTime) {
        return dateTime.map(x -> x.format(DateTimeFormatter.ISO_DATE_TIME)).orElse(NO_DATE_TIME);
    }

    public static Optional<OffsetDateTime> secondsToDateTime(long seconds) {
        return seconds == 0L ? Optional.empty() : Optional.of(OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneOffset.UTC));
    }

    public static Optional<OffsetDateTime> millisToDateTime(long millis) {
        return millis == 0L ? Optional.empty() : Optional.of(OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC));
    }
}

