/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.util.Locale;
import org.apache.knox.gateway.cloud.idbroker.common.OperationDuration;
import org.slf4j.Logger;

public class DurationInfo
extends OperationDuration
implements AutoCloseable {
    private final String text;
    private final Logger log;
    private final boolean logAtInfo;

    public DurationInfo(Logger log, String format, Object ... args) {
        this(log, true, format, args);
    }

    public DurationInfo(Logger log, boolean logAtInfo, String format, Object ... args) {
        this.text = String.format(Locale.ROOT, format, args);
        this.log = log;
        this.logAtInfo = logAtInfo;
        if (logAtInfo) {
            log.info("Starting: {}", (Object)this.text);
        } else {
            log.debug("Starting: {}", (Object)this.text);
        }
    }

    @Override
    public String toString() {
        return this.text + ": duration " + super.toString();
    }

    @Override
    public void close() {
        this.finished();
        if (this.logAtInfo) {
            this.log.info("{}", (Object)this);
        } else {
            this.log.debug("{}", (Object)this);
        }
    }
}

