/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.cloud.idbroker.common.EndpointManager;
import org.apache.knox.gateway.cloud.idbroker.common.RandomEndpointManager;
import org.apache.knox.gateway.cloud.idbroker.common.RequestErrorHandlingAttributes;
import org.apache.knox.gateway.cloud.idbroker.common.RequestExecutor;
import org.apache.knox.gateway.shell.AbstractCloudAccessBrokerRequest;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.ErrorResponse;
import org.apache.knox.gateway.shell.KnoxShellException;
import org.apache.knox.gateway.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestExecutor
implements RequestExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestExecutor.class);
    private static final List<Integer> retryStatusCodes = Arrays.asList(404, 503, 504);
    private final EndpointManager endpointManager;
    private final RequestErrorHandlingAttributes requestErrorHandlingAttributes;

    public DefaultRequestExecutor(List<String> endpoints, RequestErrorHandlingAttributes requestErrorHandlingAttributes) {
        this(new RandomEndpointManager(endpoints), requestErrorHandlingAttributes);
    }

    public DefaultRequestExecutor(EndpointManager endpointManager, RequestErrorHandlingAttributes requestErrorHandlingAttributes) {
        this.endpointManager = endpointManager;
        this.requestErrorHandlingAttributes = requestErrorHandlingAttributes;
    }

    @Override
    public String getEndpoint() {
        return this.endpointManager.getActiveURL();
    }

    @Override
    public List<String> getConfiguredEndpoints() {
        return this.endpointManager.getURLs();
    }

    @Override
    public <T> T execute(AbstractCloudAccessBrokerRequest<T> request) {
        Object response;
        try {
            response = request.now();
        }
        catch (KnoxShellException e) {
            LOG.error("Error executing request: {}", (Object)e.getMessage());
            if (this.shouldRetry(request, e)) {
                try {
                    Thread.sleep(this.requestErrorHandlingAttributes.getRetrySleepInMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                request.recordRetryAttempt();
                LOG.info("Retry attempt {} ...", (Object)request.retryAttempts());
                response = this.execute(request);
            }
            if (this.shouldFailover(request, e)) {
                LOG.info("Failover attempt {} ...", (Object)(request.failoverAttempts() + 1));
                response = this.failoverRequest(request);
            }
            Throwable cause = e.getCause();
            if (ErrorResponse.class.isAssignableFrom(cause.getClass())) {
                throw (ErrorResponse)cause;
            }
            throw e;
        }
        return (T)response;
    }

    private <T> T failoverRequest(AbstractCloudAccessBrokerRequest<T> request) throws KnoxShellException {
        T response;
        String currentEndpoint = this.endpointManager.getActiveURL();
        String topology = request.getSession().base().substring(currentEndpoint.length());
        this.endpointManager.markFailed(currentEndpoint);
        CloudAccessBrokerSession cabSession = request.getSession();
        try {
            String newEndpoint = this.endpointManager.getActiveURL();
            Map headers = cabSession.getHeaders();
            URL newUrl = new URL(newEndpoint);
            headers.put("Host", newUrl.getHost());
            cabSession.setHeaders(headers);
            LOG.info("Failing over to {}", (Object)newEndpoint);
            cabSession.updateEndpoint(newEndpoint + topology);
            LOG.info("Updated session endpoint base {}", (Object)cabSession.base());
            try {
                Thread.sleep(this.requestErrorHandlingAttributes.getFailoverSleepInMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            request.recordFailoverAttempt();
            response = this.execute(request);
        }
        catch (ErrorResponse | KnoxShellException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KnoxShellException((Throwable)e);
        }
        return response;
    }

    private boolean shouldFailover(AbstractCloudAccessBrokerRequest<?> request, KnoxShellException e) {
        boolean relevantConnectionError = HttpUtils.isRelevantConnectionError((Throwable)e.getCause());
        boolean hasMoreEndpoints = this.getConfiguredEndpoints().size() > 1;
        boolean attemptsNotExceeded = request.failoverAttempts() < this.requestErrorHandlingAttributes.getMaxFailoverAttempts();
        boolean shouldFailover = relevantConnectionError && hasMoreEndpoints && attemptsNotExceeded;
        String exceptionCause = e.getCause() == null ? "null" : e.getCause().getClass().getCanonicalName();
        LOG.info("Should failover = " + shouldFailover + " = [" + hasMoreEndpoints + " & " + attemptsNotExceeded + " & " + relevantConnectionError + " (" + exceptionCause + ")]");
        return shouldFailover;
    }

    private boolean shouldRetry(AbstractCloudAccessBrokerRequest<?> request, KnoxShellException e) {
        boolean shouldRetry;
        String exceptionCause;
        boolean isRetryException = this.isRetryException(e);
        boolean attemptsNotExceeded = request.retryAttempts() < this.requestErrorHandlingAttributes.getMaxRetryAttempts();
        String string = exceptionCause = e.getCause() == null ? "null" : e.getCause().getClass().getCanonicalName();
        if (isRetryException) {
            shouldRetry = attemptsNotExceeded;
            LOG.info("Should retry = " + shouldRetry + " = [" + attemptsNotExceeded + " & " + isRetryException + " (" + exceptionCause + "))]");
        } else {
            boolean hasOneEndpoint = this.getConfiguredEndpoints().size() == 1;
            boolean relevantConnectionError = HttpUtils.isRelevantConnectionError((Throwable)e.getCause());
            shouldRetry = attemptsNotExceeded && hasOneEndpoint && relevantConnectionError;
            LOG.info("Should retry = " + shouldRetry + " = [" + attemptsNotExceeded + " & " + hasOneEndpoint + " & " + relevantConnectionError + " (" + exceptionCause + "))]");
        }
        return shouldRetry;
    }

    private boolean isRetryException(KnoxShellException e) {
        boolean result = false;
        Throwable cause = e.getCause();
        if (cause != null && ErrorResponse.class.isAssignableFrom(cause.getClass())) {
            ErrorResponse response = (ErrorResponse)cause;
            result = retryStatusCodes.contains(response.getResponse().getStatusLine().getStatusCode());
        }
        return result;
    }
}

