/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtils.class);
    private static final String[] SSL_CLIENT_CONF_PROPS = new String[]{"ssl.client.truststore.location", "ssl.client.keystore.location", "ssl.client.truststore.type", "ssl.client.keystore.type"};

    public static boolean useCABCertFromDelegationToken(Configuration conf, String prefix) {
        return conf.getBoolean(prefix + "use.dt.cert", false);
    }

    public static String getTruststoreLocation(Configuration conf, String propertyName) {
        return CommonUtils.getTruststoreLocation(conf, propertyName, null);
    }

    public static String getTruststoreLocation(Configuration conf, String propertyName, String defaultValue) {
        String result = conf.getTrimmed(propertyName);
        if (StringUtils.isBlank((CharSequence)result)) {
            CommonUtils.ensureSSLClientConfigLoaded(conf);
            result = conf.getTrimmed("ssl.client.truststore.location");
            if (StringUtils.isBlank((CharSequence)result)) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static String getTruststorePass(Configuration conf, String propertyName) {
        return CommonUtils.getTruststorePass(conf, propertyName, null);
    }

    public static String getTruststorePass(Configuration conf, String propertyName, String defaultValue) {
        String result = CommonUtils.getPassword(conf, propertyName);
        if (StringUtils.isBlank((CharSequence)result)) {
            CommonUtils.ensureSSLClientConfigLoaded(conf);
            result = CommonUtils.getPassword(conf, "ssl.client.truststore.password");
            if (StringUtils.isBlank((CharSequence)result)) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static String getPassword(Configuration conf, String key) {
        String result = null;
        try {
            char[] secret = conf.getPassword(key);
            if (secret != null && secret.length > 0) {
                result = new String(secret);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void ensureSSLClientConfigLoaded(Configuration conf) {
        String sslClientConfigLocation = conf.getTrimmed("hadoop.ssl.client.conf");
        if (!StringUtils.isBlank((CharSequence)sslClientConfigLocation) && !CommonUtils.hasSSLClientConfiguration(conf)) {
            conf.addResource(sslClientConfigLocation);
        }
    }

    private static boolean hasSSLClientConfiguration(Configuration conf) {
        boolean result = false;
        for (String prop : SSL_CLIENT_CONF_PROPS) {
            if (conf.get(prop) == null) continue;
            result = true;
            break;
        }
        return result;
    }

    public static <T extends DelegationTokenIdentifier> Token<T> lookupToken(Credentials credentials, Text service, Text expectedKind) throws IOException {
        if (expectedKind == null) {
            throw new IllegalArgumentException("expectedKind is null");
        }
        LOG.debug("Looking for token for service {} in credentials", (Object)service);
        Token token = credentials.getToken(service);
        if (token != null) {
            Text actualKind = token.getKind();
            LOG.debug("Found token of kind {}", (Object)actualKind);
            if (expectedKind.equals((Object)actualKind)) {
                return token;
            }
            throw new IOException("Token mismatch: expected token for " + service + " of type " + expectedKind + " but got a token of type " + actualKind);
        }
        LOG.debug("No token for {} found", (Object)service);
        return null;
    }
}

