/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.http.client.config.RequestConfig;
import org.apache.knox.gateway.cloud.idbroker.IDBProperty;
import org.apache.knox.gateway.cloud.idbroker.common.DefaultRequestExecutor;
import org.apache.knox.gateway.cloud.idbroker.common.RequestErrorHandlingAttributes;
import org.apache.knox.gateway.cloud.idbroker.common.RequestExecutor;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.ClientContext;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.knox.token.CloudAccessBrokerTokenRenew;
import org.apache.knox.gateway.shell.knox.token.CloudAccessBrokerTokenRevoke;
import org.apache.knox.gateway.shell.knox.token.Renew;
import org.apache.knox.gateway.shell.knox.token.Revoke;
import org.apache.knox.gateway.util.Tokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIDBTokenRenewer
extends TokenRenewer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIDBTokenRenewer.class);
    private static final String ERR_INVALID_RENEWER = "The user (%s) does not match the renewer declared for the token: %s";
    private final Lock requestExecutorInitLock = new ReentrantLock(true);
    private RequestExecutor requestExecutor;

    public boolean isManaged(Token<?> token) throws IOException {
        return this.isManaged(token.decodeIdentifier());
    }

    public boolean isManaged(TokenIdentifier identifier) throws IOException {
        boolean managed = false;
        if (this.handleKind(identifier.getKind())) {
            DelegationTokenIdentifier dtIdentifier = (DelegationTokenIdentifier)identifier;
            managed = this.isManagedToken(dtIdentifier);
        }
        return managed;
    }

    /*
     * Unable to fully structure code
     */
    public long renew(Token<?> token, Configuration configuration) throws IOException, InterruptedException {
        result = 0L;
        identifier = token.decodeIdentifier();
        AbstractIDBTokenRenewer.LOG.debug("Token: " + identifier.toString());
        result = TimeUnit.SECONDS.toMillis(this.getTokenExpiration((DelegationTokenIdentifier)identifier));
        if (!this.isManaged(identifier)) ** GOTO lbl24
        dtIdentifier = (DelegationTokenIdentifier)identifier;
        AbstractIDBTokenRenewer.LOG.info("Renewing " + identifier.toString());
        accessToken = this.getAccessToken(dtIdentifier);
        if (accessToken == null || accessToken.isEmpty()) {
            AbstractIDBTokenRenewer.LOG.info("Skipping Knox Token renewal because it's null or empty");
            return result;
        }
        user = UserGroupInformation.getCurrentUser();
        if (AbstractIDBTokenRenewer.validateRenewer(user, dtIdentifier)) {
            try {
                AbstractIDBTokenRenewer.LOG.info("Renewing access token: " + Tokens.getTokenDisplayText((String)accessToken));
                response = this.requestRenewal(accessToken, configuration, user);
                if (response < 0L) ** GOTO lbl25
                result = response;
            }
            catch (Exception e) {
                AbstractIDBTokenRenewer.LOG.error("Error renewing token: " + e.getMessage());
                throw new IOException("Error renewing token", e);
            }
        } else {
            throw new IOException("Invalid renewer: " + user.getShortUserName());
lbl24:
            // 1 sources

            AbstractIDBTokenRenewer.LOG.info("Skipping renewal of non-managed token: " + identifier.toString());
        }
lbl25:
        // 3 sources

        AbstractIDBTokenRenewer.LOG.debug("Updated token expiration: " + result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long requestRenewal(String accessToken, Configuration configuration, UserGroupInformation renewer) throws Exception {
        long result = -1L;
        RequestExecutor re = this.getRequestExecutor(configuration);
        ClientContext context = ClientContext.with((String)re.getEndpoint());
        context.kerberos().enable(true);
        CloudAccessBrokerSession session = CloudAccessBrokerSession.create((ClientContext)context);
        Renew.Request request = org.apache.knox.gateway.shell.knox.token.Token.renew((KnoxSession)session, (String)accessToken, (String)renewer.getShortUserName());
        RequestConfig requestConfig = this.getHttpRequestConfiguration(configuration);
        if (requestConfig != null) {
            LOG.debug("Using HTTP request config: " + requestConfig.toString());
        }
        request.setHttpRequestConfig(requestConfig);
        BasicResponse response = (BasicResponse)renewer.doAs(() -> (BasicResponse)re.execute(new CloudAccessBrokerTokenRenew(request)));
        String responseEntity = response.getString();
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            if (response.getContentLength() <= 0L) return result;
            if (!"application/json".equals(response.getContentType())) return result;
            Map<String, Object> json = AbstractIDBTokenRenewer.parseJSONResponse(responseEntity);
            boolean isRenewed = Boolean.parseBoolean((String)json.getOrDefault("renewed", "false"));
            if (isRenewed) {
                LOG.debug("Token renewed.");
                String expirationValue = (String)json.get("expires");
                if (expirationValue == null) return result;
                if (expirationValue.isEmpty()) return result;
                return Long.parseLong(expirationValue);
            }
            LOG.error("Token could not be renewed: " + json.get("error"));
            throw new IOException("Token could not be renewed: " + json.get("error"));
        }
        LOG.error("Failed to renew token: " + statusCode);
        if (responseEntity == null) throw new IOException("Failed to renew token: " + statusCode);
        LOG.error(responseEntity);
        throw new IOException("Failed to renew token: " + statusCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancel(Token<?> token, Configuration configuration) throws IOException, InterruptedException {
        TokenIdentifier identifier = token.decodeIdentifier();
        if (this.isManaged(identifier)) {
            LOG.info("Canceling " + identifier.toString());
            DelegationTokenIdentifier dtIdentifier = (DelegationTokenIdentifier)identifier;
            LOG.debug("Token: " + dtIdentifier.toString());
            String accessToken = this.getAccessToken(dtIdentifier);
            if (accessToken == null || accessToken.isEmpty()) {
                LOG.info("Skipping Knox Token revocation because it's null or empty");
                return;
            }
            UserGroupInformation user = UserGroupInformation.getCurrentUser();
            if (!AbstractIDBTokenRenewer.validateRenewer(user, dtIdentifier)) throw new IOException("Invalid renewer: " + user.getShortUserName());
            try {
                LOG.info("Revoking access token: " + Tokens.getTokenDisplayText((String)accessToken));
                this.requestRevocation(accessToken, configuration, user);
                return;
            }
            catch (Exception e) {
                LOG.error("Error canceling token: " + e.getMessage());
                throw new IOException("Error canceling token", e);
            }
        } else {
            LOG.info("Skipping revocation of non-managed token: " + identifier.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void requestRevocation(String accessToken, Configuration configuration, UserGroupInformation renewer) throws Exception {
        RequestExecutor re = this.getRequestExecutor(configuration);
        ClientContext context = ClientContext.with((String)re.getEndpoint());
        context.kerberos().enable(true);
        CloudAccessBrokerSession session = CloudAccessBrokerSession.create((ClientContext)context);
        Revoke.Request request = org.apache.knox.gateway.shell.knox.token.Token.revoke((KnoxSession)session, (String)accessToken, (String)renewer.getShortUserName());
        RequestConfig requestConfig = this.getHttpRequestConfiguration(configuration);
        if (requestConfig != null) {
            LOG.debug("Using HTTP request config: " + requestConfig.toString());
        }
        request.setHttpRequestConfig(requestConfig);
        BasicResponse response = (BasicResponse)renewer.doAs(() -> (BasicResponse)re.execute(new CloudAccessBrokerTokenRevoke(request)));
        String responseEntity = null;
        try {
            responseEntity = response.getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int statusCode = response.getStatusCode();
        if (statusCode == 200) {
            if (responseEntity == null) return;
            if (response.getContentLength() <= 0L) return;
            if (!"application/json".equals(response.getContentType())) return;
            Map<String, Object> json = AbstractIDBTokenRenewer.parseJSONResponse(responseEntity);
            boolean isCanceled = Boolean.parseBoolean((String)json.getOrDefault("revoked", "false"));
            if (!isCanceled) {
                Object error = json.get("error");
                LOG.error("Token could not be canceled: " + (String)error);
                throw new IOException("Token could not be canceled: " + json.get("error"));
            }
        } else {
            LOG.error("Failed to cancel token: " + statusCode);
            boolean serverManagedTokenStateEnabled = true;
            if (responseEntity != null) {
                LOG.error(responseEntity);
                Map<String, Object> json = AbstractIDBTokenRenewer.parseJSONResponse(responseEntity);
                String error = (String)json.get("error");
                if (error.contains("not configured")) {
                    return;
                }
            }
            if (!serverManagedTokenStateEnabled) return;
            throw new IOException("Failed to cancel token: " + statusCode);
        }
        LOG.info("Token canceled.");
    }

    protected abstract List<String> getGatewayAddressConfigProperty(Configuration var1);

    protected abstract String getDelegationTokenPathConfigProperty(Configuration var1);

    protected abstract String getAccessToken(DelegationTokenIdentifier var1);

    protected abstract long getTokenExpiration(DelegationTokenIdentifier var1);

    protected abstract RequestErrorHandlingAttributes getRequestErrorHandlingAttributes(Configuration var1);

    protected abstract RequestConfig getHttpRequestConfiguration(Configuration var1);

    protected abstract boolean isManagedToken(DelegationTokenIdentifier var1);

    private List<String> getTokenEndpoints(Configuration config) {
        ArrayList<String> tokenEndpoints = new ArrayList<String>();
        String dtPath = this.getDelegationTokenPathConfigProperty(config);
        List<String> gateways = this.getGatewayAddressConfigProperty(config);
        for (String gateway : gateways) {
            String tokenEndpoint = gateway + (gateway.endsWith("/") ? "" : "/") + dtPath;
            tokenEndpoints.add(tokenEndpoint);
        }
        return tokenEndpoints;
    }

    protected RequestExecutor getRequestExecutor(Configuration conf) {
        this.requestExecutorInitLock.lock();
        try {
            if (this.requestExecutor == null) {
                this.requestExecutor = new DefaultRequestExecutor(this.getTokenEndpoints(conf), this.getRequestErrorHandlingAttributes(conf));
            }
            RequestExecutor requestExecutor = this.requestExecutor;
            return requestExecutor;
        }
        finally {
            this.requestExecutorInitLock.unlock();
        }
    }

    private static boolean validateRenewer(UserGroupInformation candidate, DelegationTokenIdentifier identifier) throws IllegalArgumentException {
        boolean isValid = true;
        Text declaredRenewer = identifier.getRenewer();
        if (declaredRenewer != null && declaredRenewer.getLength() > 0) {
            if (!declaredRenewer.toString().equals(candidate.getShortUserName())) {
                LOG.error(String.format(Locale.getDefault(), ERR_INVALID_RENEWER, candidate.getUserName(), declaredRenewer));
                isValid = false;
            }
        } else {
            LOG.error("Operation not permitted. No renewer is specified in the identifier.");
            isValid = false;
        }
        return isValid;
    }

    private static Map<String, Object> parseJSONResponse(String response) throws IOException {
        return (Map)new ObjectMapper().readValue(response, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    protected int getIntValue(Configuration configuration, IDBProperty property) {
        return configuration.getInt(property.getPropertyName(), Integer.parseInt(property.getDefaultValue()));
    }
}

